/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.Piece;

public class Board {
    protected int _size = 8;
    private int _filledRows = 3;
    public Piece[][] _board;
    protected boolean _movesWhite;
    private static Board _preset = new Board();
    private static boolean _presetFlag = false;

    public static Board getPreset() {
        Board preset = new Board(_preset);
        return preset;
    }

    public static void saveBoardAsPreset(Board anotherBoard) {
        _presetFlag = true;
        _preset = new Board(anotherBoard);
    }

    public static void setPresetField(int x, int y, boolean color, boolean king) {
        if (Board._preset._board[x][y] != null) {
            if (color != king) {
                if (Board._preset._board[x][y].empty) {
                    Board._preset._board[x][y].empty = false;
                    Board._preset._board[x][y].white = true;
                    Board._preset._board[x][y].king = king;
                } else {
                    if (color) {
                        boolean bl = Board._preset._board[x][y].white = !Board._preset._board[x][y].white;
                    }
                    if (king) {
                        Board._preset._board[x][y].king = !Board._preset._board[x][y].king;
                    }
                }
            } else {
                Board._preset._board[x][y].empty = true;
            }
        }
    }

    public static boolean getPresetFlag() {
        return _presetFlag;
    }

    public static void setPresetFlag(boolean state) {
        _presetFlag = state;
    }

    Board() {
        this._size = 8;
        this._filledRows = 3;
        this._board = new Piece[this._size][this._size];
        for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                this._board[i][j] = new Piece();
            }
        }
        this._movesWhite = true;
    }

    Board(int size, int filledRows) {
        this._size = size;
        this._filledRows = filledRows;
        this._board = new Piece[this._size][this._size];
        for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                this._board[i][j] = new Piece();
            }
        }
        this._movesWhite = true;
    }

    Board(int size) {
        this._size = size;
        this._filledRows = 3;
        this._board = new Piece[this._size][this._size];
        for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                this._board[i][j] = new Piece();
            }
        }
        this._movesWhite = true;
    }

    Board(Board anotherBoard) {
        this._size = anotherBoard._size;
        this._filledRows = anotherBoard._filledRows;
        this._board = new Piece[this._size][this._size];
        for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                this._board[i][j] = new Piece(anotherBoard._board[i][j]);
            }
        }
        this._movesWhite = anotherBoard._movesWhite;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int getSize() {
        return this._size;
    }

    public void setFilledRows(int filledRows) {
        this._filledRows = filledRows;
    }

    public int getFilledRows() {
        return this._filledRows;
    }

    public void setMovesWhite(boolean movesWhite) {
        this._movesWhite = movesWhite;
    }

    public boolean getMovesWhite() {
        return this._movesWhite;
    }

    public Piece[][] getBoard() {
        return this._board;
    }

    public boolean prepareBoard() {
        boolean retval = false;
        if (!Board.getPresetFlag() || _preset.getSize() != this.getSize()) {
            Board.setPresetFlag(false);
            if (this._filledRows * 2 <= this._size) {
                for (int i = 0; i < this._size; ++i) {
                    for (int j = (i + 1) % 2; j < this._size; j += 2) {
                        if (i < this._filledRows) {
                            this._board[i][j].empty = false;
                            this._board[i][j].white = true;
                            this._board[i][j].king = false;
                            continue;
                        }
                        if (i >= this._size - this._filledRows) {
                            this._board[i][j].empty = false;
                            this._board[i][j].white = false;
                            this._board[i][j].king = false;
                            continue;
                        }
                        this._board[i][j].empty = true;
                    }
                }
                retval = true;
            }
        } else {
            for (int i = 0; i < this._size; ++i) {
                for (int j = (i + 1) % 2; j < this._size; j += 2) {
                    this._board[i][j] = Board._preset._board[i][j];
                }
            }
        }
        return retval;
    }

    public boolean isEqual(Board anotherBoard) {
        boolean retval = true;
        block0: for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                if (anotherBoard._board[i][j].isEqual(this._board[i][j])) continue;
                retval = false;
                continue block0;
            }
        }
        return retval;
    }

    public void printBoard() {
        for (int i = 0; i < this._size; ++i) {
            for (int j = (i + 1) % 2; j < this._size; j += 2) {
                if (j == 1) {
                    System.out.print(" ");
                }
                if (!this._board[i][j].empty) {
                    if (this._board[i][j].white) {
                        if (this._board[i][j].king) {
                            System.out.print("W");
                        } else {
                            System.out.print("w");
                        }
                    } else if (this._board[i][j].king) {
                        System.out.print("B");
                    } else {
                        System.out.print("b");
                    }
                } else {
                    System.out.print("-");
                }
                if (j == this._size - 1) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }
}

