/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.Board;
import checkers.Compiler;
import checkers.Judge;
import checkers.Mutex;
import checkers.PlayerAI;
import checkers.Window;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GUI
extends JFrame
implements ActionListener {
    private boolean _upperPlayersHeuristicIsLoaded = false;
    private boolean _lowerPlayersHeuristicIsLoaded = false;
    private Locale _loc = Locale.getDefault();
    public ResourceBundle _msg = ResourceBundle.getBundle("Messages", this._loc);
    private static final Mutex _textFieldMutex = new Mutex();
    protected Window _window = new Window();
    JMenuBar _menubar = new JMenuBar();
    JMenuBar _heuristicsMenubar = new JMenuBar();
    JFrame _logWindow = new JFrame(this._msg.getString("LogWindowName"));
    TextArea _logArea = new TextArea();
    JFrame _heuristicsWindow = new JFrame(this._msg.getString("HeuristicsWindowName"));
    JTextArea _heuristicsArea = new JTextArea();
    JScrollPane _scrollHeuristicsArea = new JScrollPane(this._heuristicsArea);
    JFrame _testerWindow = new JFrame(this._msg.getString("GameControlName"));
    JButton _testReset = new JButton(this._msg.getString("Reset"));
    JButton _testTest = new JButton(this._msg.getString("Play"));
    JButton _testGames = new JButton(this._msg.getString("NoOfGames") + ": " + Judge.getNumberOfTests());
    JButton _gameReset = new JButton(this._msg.getString("GameReset"));
    JTextField _testLower = new JTextField("0");
    JTextField _testUpper = new JTextField("0");
    JTextField _testDraw = new JTextField("0");
    JLabel _testLowerSign = new JLabel(this._msg.getString("Red"));
    JLabel _testUpperSign = new JLabel(this._msg.getString("Yellow"));
    JLabel _testDrawSign = new JLabel(this._msg.getString("Draw"));
    private JMenu[] _heuristicsMenu = new JMenu[]{new JMenu(this._msg.getString("Options"))};
    private JMenuItem[] _heuristicsMenuItem = new JMenuItem[]{new JMenuItem(this._msg.getString("UpperPlayerSave")), new JMenuItem(this._msg.getString("LowerPlayerSave")), new JMenuItem(this._msg.getString("LoadExampleHeuristic")), new JMenuItem(this._msg.getString("LoadInternalHeuristic"))};
    private JMenuItem[] _langMenuItem = new JMenuItem[]{new JMenuItem(this._msg.getString("polish")), new JMenuItem(this._msg.getString("english")), new JMenuItem(this._msg.getString("spanish")), new JMenuItem(this._msg.getString("russian"))};
    private JMenu[] _menu = new JMenu[]{new JMenu(this._msg.getString("Settings")), new JMenu(this._msg.getString("Help")), new JMenu(this._msg.getString("View")), new JMenu(this._msg.getString("Language"))};
    private JMenuItem[] _viewMenuItem = new JMenuItem[]{new JMenuItem(this._msg.getString("LogWindow")), new JMenuItem(this._msg.getString("HeuristicsWindow")), new JMenuItem(this._msg.getString("GameControl"))};
    private JMenu[] _gameMenu = new JMenu[]{new JMenu(this._msg.getString("Players")), new JMenu(this._msg.getString("AILevel")), new JMenu(this._msg.getString("Board"))};
    private JMenu[] _boardMenu = new JMenu[]{new JMenu(this._msg.getString("BoardSize")), new JMenu(this._msg.getString("FilledRows"))};
    private JMenuItem _editBoardItem = new JMenuItem(this._msg.getString("Edit"));
    private JRadioButtonMenuItem[] _boardSizeItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem("2"), new JRadioButtonMenuItem("3"), new JRadioButtonMenuItem("4"), new JRadioButtonMenuItem("5"), new JRadioButtonMenuItem("6"), new JRadioButtonMenuItem("7"), new JRadioButtonMenuItem("8"), new JRadioButtonMenuItem("9"), new JRadioButtonMenuItem("10"), new JRadioButtonMenuItem("11"), new JRadioButtonMenuItem("12"), new JRadioButtonMenuItem("13"), new JRadioButtonMenuItem("14"), new JRadioButtonMenuItem("15"), new JRadioButtonMenuItem("16")};
    private ButtonGroup _boardSizeGroup = new ButtonGroup();
    private JRadioButtonMenuItem[] _filledRowsItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem("1"), new JRadioButtonMenuItem("2"), new JRadioButtonMenuItem("3"), new JRadioButtonMenuItem("4"), new JRadioButtonMenuItem("5"), new JRadioButtonMenuItem("6"), new JRadioButtonMenuItem("7")};
    private ButtonGroup _filedRowsGroup = new ButtonGroup();
    private JRadioButtonMenuItem[] _aiLevelItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem("1"), new JRadioButtonMenuItem("2"), new JRadioButtonMenuItem("3"), new JRadioButtonMenuItem("4"), new JRadioButtonMenuItem("5"), new JRadioButtonMenuItem("6"), new JRadioButtonMenuItem("7"), new JRadioButtonMenuItem("8"), new JRadioButtonMenuItem("9"), new JRadioButtonMenuItem("10"), new JRadioButtonMenuItem("11"), new JRadioButtonMenuItem("12"), new JRadioButtonMenuItem("13"), new JRadioButtonMenuItem("14"), new JRadioButtonMenuItem("15")};
    private ButtonGroup _aiLevelGroup = new ButtonGroup();
    private JMenu[] _playersMenu = new JMenu[]{new JMenu(this._msg.getString("UpperPlayer")), new JMenu(this._msg.getString("LowerPlayer"))};
    private JRadioButtonMenuItem[] _upperPlayerItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(this._msg.getString("Human")), new JRadioButtonMenuItem(this._msg.getString("AI"))};
    private ButtonGroup _upperPlayerGroup = new ButtonGroup();
    private JRadioButtonMenuItem[] _lowerPlayerItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem(this._msg.getString("Human")), new JRadioButtonMenuItem(this._msg.getString("AI"))};
    private ButtonGroup _lowerPlayerGroup = new ButtonGroup();
    private JMenuItem[] _gameMenuItems = new JMenuItem[]{new JMenuItem(this._msg.getString("GameReset")), new JMenuItem(this._msg.getString("RandSeed") + ": " + Judge.getRandSeed()), new JMenuItem(this._msg.getString("AILevel") + ": " + PlayerAI.getLevel()), new JMenuItem(this._msg.getString("AnimationSpeed") + ": " + Judge.getSleepTime()), new JMenuItem(this._msg.getString("DrawLimit") + ": " + Judge.getDrawLimit()), new JMenuItem(this._msg.getString("Pause")), new JMenuItem(this._msg.getString("EndGame"))};
    private JMenuItem[] _helpMenuItems = new JMenuItem[]{new JMenuItem(this._msg.getString("AboutAuthor")), new JMenuItem(this._msg.getString("Version"))};
    private int _windowWidth = 450;
    private int _windowHeight = 490;
    private int _boardWidth = 400;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateLog() {
        Mutex mutex = _textFieldMutex;
        synchronized (mutex) {
            this._logArea.append(Judge.getLog());
            this._logWindow.repaint();
            this.repaint();
        }
    }

    public synchronized void translate(String lang) {
        Locale.setDefault(new Locale(lang));
        this._loc = Locale.getDefault();
        this._msg = ResourceBundle.getBundle("Messages", this._loc);
        this.setTitle(this._msg.getString("Checkers"));
        this._logWindow.setTitle(this._msg.getString("LogWindowName"));
        this._heuristicsWindow.setTitle(this._msg.getString("HeuristicsWindowName"));
        this._testerWindow.setTitle(this._msg.getString("GameControlName"));
        if (Judge.getPauseFlag()) {
            this._testTest.setText(this._msg.getString("Play"));
        } else {
            this._testTest.setText(this._msg.getString("Pause"));
        }
        this._testReset.setText(this._msg.getString("Reset"));
        this._testGames.setText(this._msg.getString("NoOfGames") + ": " + Judge.getNumberOfTests());
        this._gameReset.setText(this._msg.getString("GameReset"));
        this._testLowerSign.setText(this._msg.getString("Red"));
        this._testUpperSign.setText(this._msg.getString("Yellow"));
        this._testDrawSign.setText(this._msg.getString("Draw"));
        this._heuristicsMenu[0].setText(this._msg.getString("Options"));
        this._heuristicsMenuItem[0].setText(this._msg.getString("UpperPlayerSave"));
        this._heuristicsMenuItem[1].setText(this._msg.getString("LowerPlayerSave"));
        this._heuristicsMenuItem[2].setText(this._msg.getString("LoadExampleHeuristic"));
        this._heuristicsMenuItem[3].setText(this._msg.getString("LoadInternalHeuristic"));
        this._menu[0].setText(this._msg.getString("Settings"));
        this._menu[1].setText(this._msg.getString("Help"));
        this._menu[2].setText(this._msg.getString("View"));
        this._menu[3].setText(this._msg.getString("Language"));
        this._editBoardItem.setText(this._msg.getString("Edit"));
        this._viewMenuItem[0].setText(this._msg.getString("LogWindow"));
        this._viewMenuItem[1].setText(this._msg.getString("HeuristicsWindow"));
        this._viewMenuItem[2].setText(this._msg.getString("GameControl"));
        this._gameMenu[0].setText(this._msg.getString("Players"));
        this._gameMenu[1].setText(this._msg.getString("AILevel"));
        this._gameMenu[2].setText(this._msg.getString("Board"));
        this._boardMenu[0].setText(this._msg.getString("BoardSize"));
        this._boardMenu[1].setText(this._msg.getString("FilledRows"));
        this._gameMenuItems[0].setText(this._msg.getString("GameReset"));
        this._gameMenuItems[1].setText(this._msg.getString("RandSeed") + ": " + Judge.getRandSeed());
        this._gameMenuItems[2].setText(this._msg.getString("AILevel") + ": " + PlayerAI.getLevel());
        this._gameMenuItems[3].setText(this._msg.getString("AnimationSpeed") + ": " + Judge.getSleepTime());
        this._gameMenuItems[4].setText(this._msg.getString("DrawLimit") + ": " + Judge.getDrawLimit());
        if (Judge.getPauseFlag()) {
            this._gameMenuItems[5].setText(this._msg.getString("Play"));
        } else {
            this._gameMenuItems[5].setText(this._msg.getString("Pause"));
        }
        this._gameMenuItems[this._gameMenuItems.length - 1].setText(this._msg.getString("EndGame"));
        this._playersMenu[0].setText(this._msg.getString("UpperPlayer"));
        this._playersMenu[1].setText(this._msg.getString("LowerPlayer"));
        this._upperPlayerItem[0].setText(this._msg.getString("Human"));
        this._upperPlayerItem[1].setText(this._msg.getString("AI"));
        this._lowerPlayerItem[0].setText(this._msg.getString("Human"));
        this._lowerPlayerItem[1].setText(this._msg.getString("AI"));
        this._helpMenuItems[0].setText(this._msg.getString("AboutAuthor"));
        this._helpMenuItems[1].setText(this._msg.getString("Version"));
        this.totalRepaint();
    }

    public void randSeedInternalChangedMessage() {
        this._gameMenuItems[1].setText(this._msg.getString("RandSeed") + ": " + Judge.getRandSeed());
        this.appendLog(this._msg.getString("RandSeedHasBeenChangedTo") + " " + Judge.getRandSeed() + "\n");
        this.appendLog(this._msg.getString("GameReset"));
    }

    public synchronized void totalRepaint() {
        this._window.totalRepaint();
        this._logWindow.repaint();
        this._heuristicsWindow.repaint();
        this._testerWindow.repaint();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLog(String string) {
        Mutex mutex = _textFieldMutex;
        synchronized (mutex) {
            this._logArea.append(string);
        }
    }

    private void heuristicsTestService() {
        Judge.setEndGameFlag(true);
        Judge.increaseTestNo();
        if (Judge.getTestHeuristicMode() && Judge.getTestNo() < Judge.getNumberOfTests()) {
            Judge.drawNewRandSeed();
            this.startGameInTestMode();
        } else {
            Judge.resetTestNo();
            Judge.setTestHeuristicMode(false);
            this._gameMenuItems[5].setEnabled(false);
            this._testTest.setEnabled(false);
        }
    }

    public synchronized void addToUpperScore() {
        int score = Integer.parseInt(this._testUpper.getText()) + 1;
        this.heuristicsTestService();
        this._testUpper.setText("" + score);
        this._testerWindow.repaint();
    }

    public synchronized void addToLowerScore() {
        int score = Integer.parseInt(this._testLower.getText()) + 1;
        this.heuristicsTestService();
        this._testLower.setText("" + score);
        this._testerWindow.repaint();
    }

    public synchronized void addToDrawScore() {
        int score = Integer.parseInt(this._testDraw.getText()) + 1;
        this.heuristicsTestService();
        this._testDraw.setText("" + score);
        this._testerWindow.repaint();
    }

    public GUI() {
        super("Checkers");
        int i;
        this.setTitle(this._msg.getString("Checkers"));
        this.setSize(this._windowWidth, this._windowHeight);
        this.setLocation(10, 10);
        this.setDefaultCloseOperation(3);
        this._logWindow.setVisible(true);
        this._logWindow.setSize(450, 200);
        this._logArea.setEditable(false);
        this._logWindow.add(this._logArea);
        this._logWindow.setDefaultCloseOperation(1);
        this._logWindow.setLocation(500, 10);
        this._testerWindow.setVisible(true);
        this._testerWindow.setSize(415, 220);
        this._testerWindow.setLocation(10, 510);
        this._testerWindow.setLayout(null);
        this._testerWindow.setResizable(true);
        this._testLower.setSize(120, 30);
        this._testUpper.setSize(120, 30);
        this._testDraw.setSize(120, 30);
        this._testLowerSign.setSize(120, 30);
        this._testUpperSign.setSize(120, 30);
        this._testDrawSign.setSize(120, 30);
        this._testLower.setEditable(false);
        this._testUpper.setEditable(false);
        this._testDraw.setEditable(false);
        this._testLower.setLocation(10, 40);
        this._testUpper.setLocation(140, 40);
        this._testDraw.setLocation(270, 40);
        this._testLowerSign.setLocation(10, 10);
        this._testUpperSign.setLocation(140, 10);
        this._testDrawSign.setLocation(270, 10);
        this._testerWindow.add(this._testLowerSign);
        this._testerWindow.add(this._testLower);
        this._testerWindow.add(this._testUpperSign);
        this._testerWindow.add(this._testUpper);
        this._testerWindow.add(this._testDrawSign);
        this._testerWindow.add(this._testDraw);
        this._gameReset.setSize(185, 40);
        this._testTest.setSize(185, 40);
        this._testGames.setSize(185, 40);
        this._testReset.setSize(185, 40);
        this._gameReset.setLocation(10, 84);
        this._testTest.setLocation(205, 84);
        this._testGames.setLocation(10, 134);
        this._testReset.setLocation(205, 134);
        this._testTest.addActionListener(this);
        this._testReset.addActionListener(this);
        this._testGames.addActionListener(this);
        this._gameReset.addActionListener(this);
        this._testerWindow.add(this._testTest);
        this._testerWindow.add(this._testReset);
        this._testerWindow.add(this._testGames);
        this._testerWindow.add(this._gameReset);
        this._heuristicsWindow.setVisible(false);
        this._heuristicsWindow.setSize(420, 300);
        this._heuristicsWindow.setResizable(true);
        this._heuristicsArea.setTabSize(2);
        this._heuristicsWindow.add(this._scrollHeuristicsArea);
        this._heuristicsWindow.setDefaultCloseOperation(1);
        this._heuristicsWindow.setLocation(505, 250);
        for (i = 0; i < this._gameMenuItems.length; ++i) {
            this._gameMenuItems[i].addActionListener(this);
        }
        for (i = 0; i < this._helpMenuItems.length; ++i) {
            this._helpMenuItems[i].addActionListener(this);
        }
        for (i = 0; i < this._upperPlayerItem.length; ++i) {
            this._upperPlayerGroup.add(this._upperPlayerItem[i]);
            this._upperPlayerItem[i].addActionListener(this);
        }
        this._upperPlayerItem[1].doClick();
        for (i = 0; i < this._lowerPlayerItem.length; ++i) {
            this._lowerPlayerGroup.add(this._lowerPlayerItem[i]);
            this._lowerPlayerItem[i].addActionListener(this);
        }
        this._lowerPlayerItem[1].doClick();
        for (i = 0; i < this._aiLevelItem.length; ++i) {
            this._aiLevelGroup.add(this._aiLevelItem[i]);
            this._aiLevelItem[i].addActionListener(this);
        }
        for (i = 0; i < this._boardSizeItem.length; ++i) {
            this._boardSizeGroup.add(this._boardSizeItem[i]);
            this._boardSizeItem[i].addActionListener(this);
        }
        for (i = 0; i < this._filledRowsItem.length; ++i) {
            this._filedRowsGroup.add(this._filledRowsItem[i]);
            this._filledRowsItem[i].addActionListener(this);
        }
        this._boardSizeItem[Judge.getBoard().getSize() - 2].doClick();
        this._filledRowsItem[Judge.getFilledRows() - 1].doClick();
        this._aiLevelItem[PlayerAI.getLevel() - 1].doClick();
        this._gameMenu[1].setVisible(false);
        this._gameMenuItems[0].setVisible(false);
        this._gameMenuItems[5].setVisible(false);
        this._menu[0].add(this._gameMenuItems[0]);
        this._menu[0].add(this._gameMenuItems[5]);
        this._menu[0].add(this._gameMenu[0]);
        this._menu[0].add(this._gameMenu[1]);
        this._menu[0].add(this._gameMenu[2]);
        this._menu[0].add(this._gameMenuItems[3]);
        this._menu[0].add(this._gameMenuItems[4]);
        this._editBoardItem.addActionListener(this);
        for (i = 0; i < this._aiLevelItem.length; ++i) {
            this._gameMenu[1].add(this._aiLevelItem[i]);
        }
        this._gameMenu[0].add(this._playersMenu[0]);
        this._gameMenu[0].add(this._playersMenu[1]);
        this._gameMenu[2].add(this._boardMenu[0]);
        this._gameMenu[2].add(this._boardMenu[1]);
        this._gameMenu[2].add(this._editBoardItem);
        for (i = 0; i < this._boardSizeItem.length; ++i) {
            this._boardMenu[0].add(this._boardSizeItem[i]);
        }
        for (i = 0; i < this._filledRowsItem.length; ++i) {
            this._boardMenu[1].add(this._filledRowsItem[i]);
        }
        this._playersMenu[0].add(this._upperPlayerItem[0]);
        this._playersMenu[0].add(this._upperPlayerItem[1]);
        this._playersMenu[1].add(this._lowerPlayerItem[0]);
        this._playersMenu[1].add(this._lowerPlayerItem[1]);
        this._menu[0].add(this._gameMenuItems[1]);
        this._menu[0].add(this._gameMenuItems[2]);
        this._menu[1].add(this._helpMenuItems[1]);
        this._menu[1].add(this._helpMenuItems[0]);
        for (i = 0; i < this._viewMenuItem.length; ++i) {
            this._viewMenuItem[i].addActionListener(this);
            this._menu[2].add(this._viewMenuItem[i]);
        }
        this._menu[2].add(this._viewMenuItem[1]);
        for (i = 0; i < this._langMenuItem.length; ++i) {
            this._langMenuItem[i].addActionListener(this);
            this._menu[3].add(this._langMenuItem[i]);
        }
        this._menu[0].add(this._gameMenuItems[this._gameMenuItems.length - 1]);
        this._menubar.add(this._menu[0]);
        this._menubar.add(this._menu[2]);
        this._menubar.add(this._menu[3]);
        this._menubar.add(this._menu[1]);
        this.setJMenuBar(this._menubar);
        for (i = 0; i < this._heuristicsMenuItem.length; ++i) {
            this._heuristicsMenuItem[i].addActionListener(this);
            this._heuristicsMenu[0].add(this._heuristicsMenuItem[i]);
        }
        this._heuristicsMenubar.add(this._heuristicsMenu[0]);
        this._heuristicsWindow.setJMenuBar(this._heuristicsMenubar);
        this._window.setFocusable(true);
        this._window.addKeyListener(this._window);
        this._window.addMouseListener(this._window);
        this._window.drawBoard(this._boardWidth);
        this._window.drawFigures(this._boardWidth);
        this.setContentPane(this._window);
        this._window.requestFocus();
        this.setVisible(true);
        this.setResizable(false);
        this._heuristicsWindow.setVisible(true);
        Judge._gui = this;
        Judge.drawNewRandSeed();
        this._gameMenuItems[0].doClick();
        this.totalRepaint();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            int exit = JOptionPane.showConfirmDialog(this, this._msg.getString("AreYouSure?"));
            if (exit == 0) {
                System.exit(0);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    private boolean checkCode(String heuristic) {
        boolean retval = true;
        if (!(heuristic.contains("public class EvaluatePosition") && heuristic.contains("package checkers;") && heuristic.contains("static private boolean _color;") && heuristic.contains("static public void changeColor(boolean color)") && heuristic.contains("static public boolean getColor()") && heuristic.contains("static public int evaluatePosition(AIBoard board)"))) {
            this.appendLog(this._msg.getString("InvalidSource"));
            retval = false;
        } else if (heuristic.contains("set")) {
            this.appendLog(this._msg.getString("SetForbidden"));
            retval = false;
        }
        return retval;
    }

    public void startGameInTestMode() {
        this._gameMenuItems[5].setEnabled(true);
        this._window.setBoardEditMode(false);
        Judge.setEndGameFlag(false);
        Judge.setPauseFlag(false);
        Judge.startGame();
        this._gameMenuItems[5].setEnabled(true);
        this._testTest.setEnabled(true);
        this._gameMenuItems[5].setText(this._msg.getString("Pause"));
        this._testTest.setText(this._msg.getString("Pause"));
        this._window.drawBoard();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int exit;
        int i;
        String inputString;
        Object source = evt.getSource();
        if (source == this._gameMenuItems[0]) {
            this._gameMenuItems[5].setEnabled(true);
            this._window.setBoardEditMode(false);
            Judge.setEndGameFlag(false);
            Judge.setPauseFlag(true);
            Judge.startGame();
            this._gameMenuItems[5].setEnabled(true);
            this._testTest.setEnabled(true);
            this._gameMenuItems[5].setText(this._msg.getString("Play"));
            this._testTest.setText(this._msg.getString("Play"));
            this._window.drawBoard();
        }
        if (source == this._gameMenuItems[1] && (inputString = JOptionPane.showInputDialog(this._msg.getString("TypeRandSeed"), (Object)Judge.getRandSeed())) != null) {
            try {
                int newRandSeed = Integer.parseInt(inputString);
                if (newRandSeed > 0) {
                    this.appendLog(this._msg.getString("RandSeedHasBeenChangedTo") + " " + newRandSeed + "\n");
                    Judge.setRandSeed(newRandSeed);
                    this._gameMenuItems[1].setText(this._msg.getString("RandSeed") + ": " + Judge.getRandSeed());
                } else {
                    this.appendLog(this._msg.getString("BadNumberFormat"));
                }
            }
            catch (NumberFormatException ex) {
                this.appendLog(this._msg.getString("BadNumberFormat"));
            }
        }
        if (source == this._gameMenuItems[2] && (inputString = JOptionPane.showInputDialog(this._msg.getString("TypeAILevel"), (Object)PlayerAI.getLevel())) != null) {
            try {
                int newAILevel = Integer.parseInt(inputString);
                if (newAILevel > 0) {
                    this.appendLog(this._msg.getString("AILevelHasBeenChangedTo") + " " + newAILevel + "\n");
                    PlayerAI.setLevel(newAILevel);
                    this._gameMenuItems[2].setText(this._msg.getString("AILevel") + ": " + PlayerAI.getLevel());
                } else {
                    this.appendLog(this._msg.getString("BadNumberFormat"));
                }
            }
            catch (NumberFormatException ex) {
                this.appendLog(this._msg.getString("BadNumberFormat"));
            }
        }
        if (source == this._gameMenuItems[3] && (inputString = JOptionPane.showInputDialog(this._msg.getString("TypeAnimationSpeed"), (Object)Judge.getSleepTime())) != null) {
            try {
                int newAnimationSpeed = Integer.parseInt(inputString);
                if (newAnimationSpeed >= 0) {
                    this.appendLog(this._msg.getString("AnimationSpeedHasBeenChangedTo") + " " + newAnimationSpeed + "\n");
                    Judge.setSleepTime(newAnimationSpeed);
                    this._gameMenuItems[3].setText(this._msg.getString("AnimationSpeed") + ": " + Judge.getSleepTime());
                } else {
                    this.appendLog(this._msg.getString("BadNumberFormat"));
                }
            }
            catch (NumberFormatException ex) {
                this.appendLog(this._msg.getString("BadNumberFormat"));
            }
        }
        if (source == this._gameMenuItems[4] && (inputString = JOptionPane.showInputDialog(this._msg.getString("TypeDrawLimit"), (Object)Judge.getDrawLimit())) != null) {
            try {
                int newDrawLimit = Integer.parseInt(inputString);
                if (newDrawLimit > 0) {
                    this.appendLog(this._msg.getString("DrawLimitHasBeenChangedTo") + ": " + newDrawLimit + "\n");
                    Judge.setDrawLimit(newDrawLimit);
                    this._gameMenuItems[4].setText(this._msg.getString("DrawLimit") + " " + Judge.getDrawLimit());
                } else {
                    this.appendLog(this._msg.getString("BadNumberFormat"));
                }
            }
            catch (NumberFormatException ex) {
                this.appendLog(this._msg.getString("BadNumberFormat"));
            }
        }
        if (source == this._gameMenuItems[5]) {
            Judge.switchPauseFlag();
            if (Judge.getPauseFlag()) {
                this._gameMenuItems[5].setText(this._msg.getString("Play"));
                this._testTest.setText(this._msg.getString("Play"));
            } else {
                this._gameMenuItems[5].setText(this._msg.getString("Pause"));
                this._testTest.setText(this._msg.getString("Pause"));
            }
        }
        if (source == this._gameMenuItems[this._gameMenuItems.length - 1]) {
            this.processWindowEvent(new WindowEvent(this, 201));
        }
        if (source == this._helpMenuItems[0]) {
            JOptionPane.showMessageDialog(null, this._msg.getString("Author") + ": Mateusz Sawicki");
        }
        if (source == this._helpMenuItems[1]) {
            JOptionPane.showMessageDialog(null, this._msg.getString("VersionMessage"));
        }
        if (source == this._upperPlayerItem[0]) {
            this.appendLog(this._msg.getString("UpperPlayerIsNowControlledByHuman"));
            Judge.setPlayer(true, false);
        }
        if (source == this._upperPlayerItem[1]) {
            this.appendLog(this._msg.getString("UpperPlayerIsNowControlledByAI"));
            if (this._upperPlayersHeuristicIsLoaded) {
                Judge.setPlayer(true, true, "EvaluatePositionUpper");
            } else {
                Judge.setPlayer(true, true);
            }
        }
        if (source == this._lowerPlayerItem[0]) {
            this.appendLog(this._msg.getString("LowerPlayerIsNowControlledByHuman"));
            Judge.setPlayer(false, false);
        }
        if (source == this._lowerPlayerItem[1]) {
            this.appendLog(this._msg.getString("LowerPlayerIsNowControlledByAI"));
            if (this._lowerPlayersHeuristicIsLoaded) {
                Judge.setPlayer(false, true, "EvaluatePositionLower");
            } else {
                Judge.setPlayer(false, true);
            }
        }
        for (i = 0; i < this._aiLevelItem.length; ++i) {
            if (source != this._aiLevelItem[i]) continue;
            PlayerAI.setLevel(i + 1);
            this.appendLog(this._msg.getString("AILevelHasBeenChangedTo") + " " + (i + 1) + "\n");
        }
        for (i = 0; i < this._boardSizeItem.length; ++i) {
            if (source != this._boardSizeItem[i]) continue;
            if (Judge.getFilledRows() > (i + 2) / 2) {
                int newFilledRows = (i + 2) / 2 - 1;
                if (newFilledRows < 1) {
                    newFilledRows = 1;
                }
                this._filledRowsItem[newFilledRows - 1].doClick();
            }
            Judge.setBoardSize(i + 2);
            Board.setPresetFlag(false);
            for (int j = 1; j < this._filledRowsItem.length; ++j) {
                if (j + 1 < Judge.getBoardSize() / 2) {
                    this._filledRowsItem[j].setVisible(true);
                    continue;
                }
                this._filledRowsItem[j].setVisible(false);
            }
            this.appendLog(this._msg.getString("BoardSizeWillBeChangedTo") + " " + (i + 2) + " " + this._msg.getString("InNextGame"));
        }
        for (i = 0; i < this._filledRowsItem.length; ++i) {
            if (source != this._filledRowsItem[i]) continue;
            if (i + 1 <= Judge.getBoardSize() / 2) {
                Judge.setFilledRows(i + 1);
                Board.setPresetFlag(false);
                this.appendLog(this._msg.getString("FilledRowsNumberWillBeChangedTo") + " " + (i + 1) + " " + this._msg.getString("InNextGame"));
                continue;
            }
            this._filledRowsItem[Judge.getFilledRows() - 1].doClick();
        }
        if (source == this._viewMenuItem[0]) {
            this._logWindow.setVisible(!this._logWindow.isVisible());
        }
        if (source == this._viewMenuItem[1]) {
            this._heuristicsWindow.setVisible(!this._heuristicsWindow.isVisible());
        }
        if (source == this._viewMenuItem[2]) {
            this._testerWindow.setVisible(!this._testerWindow.isVisible());
        }
        if (source == this._heuristicsMenuItem[0]) {
            String heuristic = this._heuristicsArea.getText();
            if (this._msg.getString("InternalHeuristicHasBeenChosen").equals(heuristic)) {
                this._upperPlayersHeuristicIsLoaded = false;
                this.appendLog(this._msg.getString("InternalHeuristicHasBeenChosen"));
                this._upperPlayerItem[1].doClick();
            } else if (this.checkCode(heuristic = heuristic.replaceAll("EvaluatePosition", "EvaluatePositionUpper"))) {
                Compiler.setSourceCode(heuristic);
                try {
                    boolean status = Compiler.compileIt("EvaluatePositionUpper", true);
                    String compilerMessages = Compiler.getCompilerMessages();
                    if (status) {
                        this._upperPlayersHeuristicIsLoaded = true;
                        this.appendLog(this._msg.getString("CompilationComplete"));
                        this._upperPlayerItem[1].doClick();
                    } else {
                        this._upperPlayersHeuristicIsLoaded = false;
                        if (compilerMessages.equals("NSC")) {
                            this.appendLog(this._msg.getString("NoSourceCode"));
                        } else {
                            this.appendLog(compilerMessages);
                        }
                    }
                }
                catch (Exception ex) {
                    this.appendLog(this._msg.getString("InvalidEnvironment"));
                }
            }
        }
        if (source == this._heuristicsMenuItem[1]) {
            String heuristic = this._heuristicsArea.getText();
            if (this._msg.getString("InternalHeuristicHasBeenChosen").equals(heuristic)) {
                this._lowerPlayersHeuristicIsLoaded = false;
                this.appendLog(this._msg.getString("InternalHeuristicHasBeenChosen"));
                this._lowerPlayerItem[1].doClick();
            } else if (this.checkCode(heuristic = heuristic.replaceAll("EvaluatePosition", "EvaluatePositionLower"))) {
                Compiler.setSourceCode(heuristic);
                try {
                    boolean status = Compiler.compileIt("EvaluatePositionLower", true);
                    String compilerMessages = Compiler.getCompilerMessages();
                    if (status) {
                        this._lowerPlayersHeuristicIsLoaded = true;
                        this.appendLog(this._msg.getString("CompilationComplete"));
                        this._lowerPlayerItem[1].doClick();
                    } else {
                        this._lowerPlayersHeuristicIsLoaded = false;
                        if (compilerMessages.equals("NSC")) {
                            this.appendLog(this._msg.getString("NoSourceCode"));
                        } else {
                            this.appendLog(compilerMessages);
                        }
                    }
                }
                catch (Exception ex) {
                    this.appendLog(this._msg.getString("InvalidEnvironment"));
                }
            }
        }
        if (source == this._heuristicsMenuItem[2]) {
            String example = "package checkers; ";
            example = example + this._msg.getString("NecessaryPackage");
            example = example + "public class EvaluatePosition ";
            example = example + this._msg.getString("NecessaryClass");
            example = example + "{\n";
            example = example + "\tstatic private final int WIN=Integer.MAX_VALUE/2;\n";
            example = example + "\tstatic private final int LOSE=Integer.MIN_VALUE/2;\n";
            example = example + "\tstatic private boolean _color; ";
            example = example + this._msg.getString("NecessaryField");
            example = example + "\tstatic public void changeColor(boolean color) ";
            example = example + this._msg.getString("NecessaryMethod");
            example = example + "\t{\n";
            example = example + "\t\t_color=color;\n";
            example = example + "\t}\n";
            example = example + "\tstatic public boolean getColor() ";
            example = example + this._msg.getString("NecessaryMethod");
            example = example + "\t{\n";
            example = example + "\t\treturn _color;\n";
            example = example + "\t}\n";
            example = example + "\tstatic public int evaluatePosition(AIBoard board) ";
            example = example + this._msg.getString("MajorMethod");
            example = example + "\t{\n";
            example = example + "\t\tint myRating=0;\n";
            example = example + "\t\tint opponentsRating=0;\n";
            example = example + "\t\tint size=board.getSize();\n";
            example = example + "\t\tfor (int i=0;i<size;i++)\n";
            example = example + "\t\t{\n";
            example = example + "\t\t\tfor (int j=(i+1)%2;j<size;j+=2)\n";
            example = example + "\t\t\t{\n";
            example = example + "\t\t\t\tif (!board._board[i][j].empty) ";
            example = example + this._msg.getString("FieldNotEmpty");
            example = example + "\t\t\t\t{\n";
            example = example + "\t\t\t\t\tif (board._board[i][j].white==getColor()) ";
            example = example + this._msg.getString("ThisIsMyPiece");
            example = example + "\t\t\t\t\t{\n";
            example = example + "\t\t\t\t\t\tif (board._board[i][j].king) myRating+=5; ";
            example = example + this._msg.getString("ThisIsMyKing");
            example = example + "\t\t\t\t\t\telse myRating+=1; ";
            example = example + this._msg.getString("ThisIsMyPiece");
            example = example + "\t\t\t\t\t}\n";
            example = example + "\t\t\t\t\telse\n";
            example = example + "\t\t\t\t\t{\n";
            example = example + "\t\t\t\t\t\tif (board._board[i][j].king) opponentsRating+=5; ";
            example = example + this._msg.getString("ThisIsOpponentsKing");
            example = example + "\t\t\t\t\t\telse opponentsRating+=1;\n";
            example = example + "\t\t\t\t\t}\n";
            example = example + "\t\t\t\t}\n";
            example = example + "\t\t\t}\n";
            example = example + "\t\t}\n";
            example = example + "\t\t//Judge.updateLog(\"";
            example = example + this._msg.getString("TypeYourMessageHere");
            example = example + "\\n\");\n";
            example = example + "\t\tif (myRating==0) return LOSE; ";
            example = example + this._msg.getString("LOSE");
            example = example + "\t\telse if (opponentsRating==0) return WIN; ";
            example = example + this._msg.getString("WIN");
            example = example + "\t\telse return myRating-opponentsRating;\n";
            example = example + "\t}\n";
            example = example + "}\n";
            this._heuristicsArea.setText(example);
        }
        if (source == this._heuristicsMenuItem[3]) {
            this._heuristicsArea.setText(this._msg.getString("InternalHeuristicHasBeenChosen"));
            this._heuristicsArea.repaint();
        }
        if (source == this._langMenuItem[0]) {
            this.translate("pl");
        }
        if (source == this._langMenuItem[1]) {
            this.translate("en");
        }
        if (source == this._langMenuItem[2]) {
            this.translate("es");
        }
        if (source == this._langMenuItem[3]) {
            this.translate("ru");
        }
        if (source == this._testReset) {
            this._testLower.setText("0");
            this._testUpper.setText("0");
            this._testDraw.setText("0");
        }
        if (source == this._testTest) {
            Judge.switchPauseFlag();
            if (Judge.getPauseFlag()) {
                this._gameMenuItems[5].setText(this._msg.getString("Play"));
                this._testTest.setText(this._msg.getString("Play"));
            } else {
                this._testTest.setText(this._msg.getString("Pause"));
                this._gameMenuItems[5].setText(this._msg.getString("Pause"));
            }
            if (!Judge.getTestHeuristicMode()) {
                Judge.setTestHeuristicMode(true);
                Judge.resetTestNo();
                this.startGameInTestMode();
            }
        }
        if (source == this._testGames && (inputString = JOptionPane.showInputDialog(this._msg.getString("TypeNoOfGames"), (Object)Judge.getNumberOfTests())) != null) {
            try {
                int newTestNumber = Integer.parseInt(inputString);
                if (newTestNumber > 0) {
                    this.appendLog(this._msg.getString("NoOfGamesHasBeenChangedTo") + " " + newTestNumber + "\n");
                    Judge.setNumberOfTests(newTestNumber);
                    this._testGames.setText(this._msg.getString("NoOfGames") + ": " + Judge.getNumberOfTests());
                } else {
                    this.appendLog(this._msg.getString("BadNumberFormat"));
                }
            }
            catch (NumberFormatException ex) {
                this.appendLog(this._msg.getString("BadNumberFormat"));
            }
        }
        if (source == this._gameReset) {
            Judge.drawNewRandSeed();
            this._gameMenuItems[0].doClick();
        }
        if (source == this._editBoardItem) {
            this._window.swapBoardEditMode();
            Board.setPresetFlag(true);
            if (this._window.getBoardEditMode()) {
                if (!Judge.getPauseFlag()) {
                    this._gameMenuItems[5].doClick();
                }
                this._gameMenuItems[5].setEnabled(false);
                this._testTest.setEnabled(false);
                Board.saveBoardAsPreset(Judge.getBoard());
            } else {
                this._testTest.setEnabled(true);
                this._gameMenuItems[5].setEnabled(true);
                this._gameMenuItems[0].doClick();
            }
        }
        if (evt.getID() == 201 && (exit = JOptionPane.showConfirmDialog(this, this._msg.getString("AreYouSure?"))) == 0) {
            System.exit(0);
        }
    }
}

