/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.AIBoard;

public class InternalEvaluatePosition {
    private static final int WIN = 0x3FFFFFFF;
    private static final int LOSE = -1073741824;
    private static boolean _color;

    public static void changeColor(boolean color) {
        _color = color;
    }

    public static boolean getColor() {
        return _color;
    }

    public static int evaluatePosition(AIBoard board) {
        int myRating = 0;
        int opponentsRating = 0;
        int size = board.getSize();
        for (int i = 0; i < size; ++i) {
            for (int j = (i + 1) % 2; j < size; j += 2) {
                if (board._board[i][j].empty) continue;
                if (board._board[i][j].white == InternalEvaluatePosition.getColor()) {
                    if (board._board[i][j].king) {
                        myRating += 5;
                        continue;
                    }
                    ++myRating;
                    continue;
                }
                if (board._board[i][j].king) {
                    opponentsRating += 5;
                    continue;
                }
                ++opponentsRating;
            }
        }
        if (myRating == 0) {
            return -1073741824;
        }
        if (opponentsRating == 0) {
            return 0x3FFFFFFF;
        }
        return myRating - opponentsRating;
    }
}

