/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.AIBoard;
import checkers.Board;
import checkers.Judge;
import checkers.Mutex;
import checkers.MyClassLoader;
import checkers.Player;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlayerAI
extends Player
implements Runnable {
    private static boolean _pauseFlag = false;
    private static final Mutex _pauseFlagMutex = new Mutex();
    private Class _evaluatePositionClass;
    private Method _evaluatePositionMethod;
    private static final int WIN = 0x3FFFFFFF;
    private static final int LOSE = -1073741824;
    private static int _maxLevel = 8;
    private static boolean _capturing = false;
    private static int _x = 0;
    private static int _y = 0;
    private static final Mutex _maxLevelMutex = new Mutex();
    private static final Mutex _movesToRankMutex = new Mutex();
    private static final Mutex _ratingsMutex = new Mutex();
    private static ArrayList<AIBoard> _movesToRank = new ArrayList();
    private static ArrayList<AIBoard> _ratings = new ArrayList();
    private static int _firstFreeIndex = 0;

    private static int getX() {
        return _x;
    }

    private static int getY() {
        return _y;
    }

    private static void setX(int x) {
        _x = x;
    }

    private static void setY(int y) {
        _y = y;
    }

    private static void setCapturingPiece(int x, int y) {
        PlayerAI.setX(x);
        PlayerAI.setY(y);
    }

    public static void setCapturing(boolean capturing) {
        _capturing = capturing;
    }

    private static boolean getCapturing() {
        return _capturing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPauseFlag() {
        boolean retval;
        Mutex mutex = _pauseFlagMutex;
        synchronized (mutex) {
            retval = _pauseFlag;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPauseFlag(boolean state) {
        Mutex mutex = _pauseFlagMutex;
        synchronized (mutex) {
            _pauseFlag = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchPauseFlag() {
        Mutex mutex = _pauseFlagMutex;
        synchronized (mutex) {
            _pauseFlag = !_pauseFlag;
        }
    }

    PlayerAI(boolean color) {
        this._color = color;
        this._IAmAHuman = false;
        try {
            this._evaluatePositionClass = Class.forName("checkers.InternalEvaluatePosition");
            this._evaluatePositionMethod = this._evaluatePositionClass.getMethod("evaluatePosition", AIBoard.class);
            this._evaluatePositionClass.getMethod("changeColor", Boolean.TYPE).invoke(null, color);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    PlayerAI(boolean color, Class evaluatePositionClass, Method evaluatePositionMethod) {
        this._color = color;
        this._IAmAHuman = false;
        this._evaluatePositionClass = evaluatePositionClass;
        this._evaluatePositionMethod = evaluatePositionMethod;
    }

    PlayerAI(boolean color, String className) {
        this._color = color;
        this._IAmAHuman = false;
        MyClassLoader mcl = new MyClassLoader(ClassLoader.getSystemClassLoader());
        try {
            this._evaluatePositionClass = mcl.loadMyClass(className);
            this._evaluatePositionClass.getMethod("changeColor", Boolean.TYPE).invoke(null, this.GetColor());
            this._evaluatePositionMethod = this._evaluatePositionClass.getMethod("evaluatePosition", AIBoard.class);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLevel(int maxLevel) {
        Mutex mutex = _maxLevelMutex;
        synchronized (mutex) {
            _maxLevel = maxLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLevel() {
        int retval;
        Mutex mutex = _maxLevelMutex;
        synchronized (mutex) {
            retval = _maxLevel;
        }
        return retval;
    }

    private void findCapturingMoveForAIBoard(AIBoard gameBoard, AIBoard newBoard) {
        for (int i = 0; i < gameBoard.getSize(); ++i) {
            for (int j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty || newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                newBoard.setCapturingPiece(i, j);
                return;
            }
        }
    }

    private void findCapturingMove(Board gameBoard, Board newBoard) {
        for (int i = 0; i < gameBoard.getSize(); ++i) {
            for (int j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty || newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                PlayerAI.setCapturingPiece(i, j);
                return;
            }
        }
    }

    public int evaluatePosition(AIBoard board) {
        int myRating = 0;
        int opponentsRating = 0;
        int size = board.getSize();
        for (int i = 0; i < size; ++i) {
            for (int j = (i + 1) % 2; j < size; j += 2) {
                if (board._board[i][j].empty) continue;
                if (board._board[i][j].white == this.GetColor()) {
                    if (board._board[i][j].king) {
                        myRating += 5;
                        continue;
                    }
                    ++myRating;
                    continue;
                }
                if (board._board[i][j].king) {
                    opponentsRating += 5;
                    continue;
                }
                ++opponentsRating;
            }
        }
        if (myRating == 0) {
            return -1073741824;
        }
        if (opponentsRating == 0) {
            return 0x3FFFFFFF;
        }
        return myRating - opponentsRating;
    }

    private ArrayList<AIBoard> generateMoves(AIBoard board) {
        ArrayList<AIBoard> retval = new ArrayList<AIBoard>();
        boolean capturing = false;
        for (int i = 0; i < board.getSize(); ++i) {
            for (int j = (i + 1) % 2; j < board.getSize(); j += 2) {
                if (board._board[i][j].empty || board._board[i][j].white != board.getMovesWhite()) continue;
                for (int k = -1; k < 2; k += 2) {
                    for (int l = -1; l < 2; l += 2) {
                        AIBoard newBoard;
                        if (i + k >= board.getSize() || i + k < 0 || j + l >= board.getSize() || j + l < 0) continue;
                        if (!capturing && board._board[i + k][j + l].empty) {
                            if (!board._board[i][j].king && (board._board[i][j].king || !board._board[i][j].white || k <= 0) && (board._board[i][j].white || k >= 0)) continue;
                            newBoard = new AIBoard(board);
                            newBoard.setMovesWhite(!board.getMovesWhite());
                            Judge.moveFigure(newBoard, i, j, i + k, j + l);
                            if (board._board[i][j].king) {
                                newBoard.setDrawCounter(board.getDrawCounter() + 1);
                            } else {
                                newBoard.resetDrawCounter();
                            }
                            retval.add(newBoard);
                            continue;
                        }
                        if (board._board[i + k][j + l].empty || board._board[i + k][j + l].white == board.getMovesWhite() || i + 2 * k >= board.getSize() || i + 2 * k < 0 || j + 2 * l >= board.getSize() || j + 2 * l < 0 || !board._board[i][j].king && (board._board[i][j].king || !board._board[i][j].white || k <= 0) && (board._board[i][j].white || k >= 0) || !board._board[i + 2 * k][j + 2 * l].empty) continue;
                        if (!capturing) {
                            retval.clear();
                        }
                        capturing = true;
                        newBoard = new AIBoard(board);
                        newBoard.resetDrawCounter();
                        newBoard.setMovesWhite(!board.getMovesWhite());
                        Judge.moveFigure(newBoard, i, j, i + 2 * k, j + 2 * l);
                        newBoard._board[i + k][j + l].empty = true;
                        if (board._board[i][j].king || !newBoard._board[i + 2 * k][j + 2 * l].king) {
                            for (int m = -1; m < 2; m += 2) {
                                for (int n = -1; n < 2; n += 2) {
                                    if (i + 2 * k + 2 * m >= board.getSize() || i + 2 * k + 2 * m < 0 || j + 2 * l + 2 * n >= board.getSize() || j + 2 * l + 2 * n < 0 || !newBoard._board[i + 2 * k + 2 * m][j + 2 * l + 2 * n].empty || newBoard._board[i + 2 * k + m][j + 2 * l + n].empty || newBoard._board[i + 2 * k + m][j + 2 * l + n].white == board.getMovesWhite() || !newBoard._board[i + 2 * k][j + 2 * l].king && (newBoard._board[i + 2 * k][j + 2 * l].king || !newBoard._board[i + 2 * k][j + 2 * l].white || m <= 0) && (newBoard._board[i + 2 * k][j + 2 * l].white || m >= 0)) continue;
                                    newBoard.setMovesWhite(board.getMovesWhite());
                                    if (board.getCapturing() && !newBoard._board[board.getX()][board.getY()].empty || board.getMovesWhite() != newBoard.getMovesWhite()) continue;
                                    newBoard.setCapturing(true);
                                    this.findCapturingMoveForAIBoard(board, newBoard);
                                }
                            }
                        }
                        retval.add(newBoard);
                    }
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Board alphaBeta(Board board) {
        Board retval;
        _ratings.clear();
        _movesToRank.clear();
        _firstFreeIndex = 0;
        try {
            this._evaluatePositionClass.getMethod("changeColor", Boolean.TYPE).invoke(null, this._color);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
        }
        AIBoard myBoard = new AIBoard(board);
        myBoard.setDrawCounter(Judge.getDrawCounter());
        ArrayList<AIBoard> bestMoves = new ArrayList<AIBoard>();
        int maxRating = Integer.MIN_VALUE;
        ArrayList<AIBoard> tmpAvailableMoves = this.generateMoves(myBoard);
        for (AIBoard b : tmpAvailableMoves) {
            if (PlayerAI.getCapturing() && !b._board[PlayerAI.getX()][PlayerAI.getY()].empty) continue;
            _movesToRank.add(b);
            _ratings.add(b);
        }
        PlayerAI.setCapturing(false);
        if (PlayerAI.getLevel() >= 1) {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            ArrayList<PlayerAI> playersThreads = new ArrayList<PlayerAI>();
            int size = _movesToRank.size();
            for (int i = 0; i < size; ++i) {
                int index;
                playersThreads.add(new PlayerAI(this.GetColor(), this._evaluatePositionClass, this._evaluatePositionMethod));
                threads.add(new Thread((Runnable)playersThreads.get(i)));
                Mutex mutex = _movesToRankMutex;
                synchronized (mutex) {
                    index = _firstFreeIndex;
                }
                while (i != index) {
                    mutex = _movesToRankMutex;
                    synchronized (mutex) {
                        index = _firstFreeIndex;
                    }
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                ((Thread)threads.get(i)).start();
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            playersThreads.clear();
            threads.clear();
            for (AIBoard b : _ratings) {
                if (b.getRating() > maxRating) {
                    bestMoves.clear();
                    bestMoves.add(b);
                    maxRating = b.getRating();
                    continue;
                }
                if (b.getRating() != maxRating) continue;
                bestMoves.add(b);
            }
            int index = -1;
            if (!bestMoves.isEmpty()) {
                while ((index = (int)Math.floor((double)bestMoves.size() * Judge.nextDouble())) >= bestMoves.size()) {
                }
            }
            retval = (Board)bestMoves.get(index);
        } else {
            for (AIBoard b : _ratings) {
                try {
                    b.setRating((Integer)this._evaluatePositionMethod.invoke(null, b));
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                    b.setRating(this.evaluatePosition(b));
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                    b.setRating(this.evaluatePosition(b));
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                    b.setRating(this.evaluatePosition(b));
                }
                if (b.getRating() > maxRating) {
                    maxRating = b.getRating();
                    bestMoves.clear();
                    bestMoves.add(b);
                    continue;
                }
                if (b.getRating() != maxRating) continue;
                bestMoves.add(b);
            }
            retval = (Board)bestMoves.get((int)Math.round((double)bestMoves.size() * Judge.nextDouble()));
        }
        if (retval.getMovesWhite() == board.getMovesWhite()) {
            PlayerAI.setCapturing(true);
            this.findCapturingMove(board, retval);
        }
        return retval;
    }

    private int alphaBeta(AIBoard board, int level, int alpha, int beta) {
        while (PlayerAI.getPauseFlag()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ArrayList<AIBoard> availableMoves = this.generateMoves(board);
        if (availableMoves.isEmpty()) {
            if (board.getMovesWhite() == this.GetColor()) {
                return -1073741824 + level;
            }
            return 0x3FFFFFFF - level;
        }
        if (board.getDrawCounter() >= Judge.getDrawLimit()) {
            return 0;
        }
        if (level >= PlayerAI.getLevel()) {
            try {
                return (Integer)this._evaluatePositionMethod.invoke(null, board);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                return this.evaluatePosition(board);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                return this.evaluatePosition(board);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(PlayerAI.class.getName()).log(Level.SEVERE, null, ex);
                return this.evaluatePosition(board);
            }
        }
        if (board.getMovesWhite() == this.GetColor()) {
            for (AIBoard b : availableMoves) {
                if ((alpha = Math.max(alpha, this.alphaBeta(b, level + 1, alpha, beta))) < beta) continue;
                return beta;
            }
            return alpha;
        }
        for (AIBoard b : availableMoves) {
            if (alpha < (beta = Math.min(beta, this.alphaBeta(b, level + 1, alpha, beta)))) continue;
            return alpha;
        }
        return beta;
    }

    @Override
    public Board chooseMove(Board board) {
        return this.alphaBeta(board);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AIBoard move;
        int myIndex;
        Mutex mutex = _movesToRankMutex;
        synchronized (mutex) {
            myIndex = _firstFreeIndex++;
            move = new AIBoard(_movesToRank.get(myIndex));
            move.setX(_movesToRank.get(myIndex).getX());
            move.setY(_movesToRank.get(myIndex).getY());
            move.setCapturing(_movesToRank.get(myIndex).getCapturing());
            move.setMovesWhite(_movesToRank.get(myIndex).getMovesWhite());
        }
        move.setRating(this.alphaBeta(move, 1, Integer.MIN_VALUE, Integer.MAX_VALUE));
        mutex = _ratingsMutex;
        synchronized (mutex) {
            _ratings.set(myIndex, move);
        }
    }
}

