/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.Board;
import checkers.Circle;
import checkers.Figure;
import checkers.FilledCircle;
import checkers.FilledRectangle;
import checkers.Judge;
import checkers.KingCircle;
import checkers.Mutex;
import checkers.Point;
import checkers.Rectangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

class Window
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    ArrayList<Figure> _board = new ArrayList();
    ArrayList<Figure> _figures = new ArrayList();
    private int _mouseX;
    private int _mouseY;
    private int _boardWidth;
    private int _boardXMargin = 20;
    private int _boardYMargin = 20;
    private boolean _boardEditMode = false;
    private final Mutex _boardEditModeMutex = new Mutex();

    Window() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoardEditMode() {
        boolean retval;
        Mutex mutex = this._boardEditModeMutex;
        synchronized (mutex) {
            retval = this._boardEditMode;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoardEditMode(boolean state) {
        Mutex mutex = this._boardEditModeMutex;
        synchronized (mutex) {
            this._boardEditMode = state;
        }
    }

    public void swapBoardEditMode() {
        this.setBoardEditMode(!this.getBoardEditMode());
    }

    public synchronized void totalRepaint() {
        this._figures.clear();
        this.drawFigures();
        this.repaint();
    }

    private synchronized void addFigure(Figure fig, ArrayList<Figure> list) {
        list.add(fig);
        this.repaint();
    }

    public void addCircle(float x, float y, float diameter, Color color, ArrayList<Figure> list) {
        this.addFigure(new Circle(new Point(x, y), diameter, color), list);
    }

    public void addFilledCircle(float x, float y, float diameter, Color color, ArrayList<Figure> list) {
        this.addFigure(new FilledCircle(new Point(x, y), diameter, color), list);
    }

    public void addKingCircle(float x, float y, float diameter, Color color, ArrayList<Figure> list) {
        this.addFigure(new KingCircle(new Point(x, y), diameter, color), list);
    }

    public void addRectangle(float x, float y, float width, float height, Color color, ArrayList<Figure> list) {
        this.addFigure(new Rectangle(new Point(x, y), width, height, color), list);
    }

    public void addFilledRectangle(float x, float y, float width, float height, Color color, ArrayList<Figure> list) {
        this.addFigure(new FilledRectangle(new Point(x, y), width, height, color), list);
    }

    void drawBoard(int boardWidth) {
        this._boardWidth = boardWidth;
        this.drawBoard();
    }

    void drawBoard() {
        int boardSize = Judge.getBoard().getSize();
        int x = this._boardXMargin;
        int y = this._boardYMargin;
        int fieldWidth = this._boardWidth / boardSize;
        this.addFilledRectangle(this._boardXMargin - 10, this._boardYMargin - 10, boardSize * fieldWidth + 20, boardSize * fieldWidth + 20, Figure._boardBCG, this._board);
        for (int i = 0; i < boardSize; ++i) {
            for (int j = (i + 1) % 2; j < boardSize; j += 2) {
                if (j == 1) {
                    this.addFilledRectangle(x, y + i * fieldWidth, fieldWidth, fieldWidth, Figure._boardWhite, this._board);
                }
                this.addFilledRectangle(x + j * fieldWidth, y + i * fieldWidth, fieldWidth, fieldWidth, Figure._boardBlack, this._board);
                if (j == boardSize - 1) continue;
                this.addFilledRectangle(x + (j + 1) * fieldWidth, y + i * fieldWidth, fieldWidth, fieldWidth, Figure._boardWhite, this._board);
            }
        }
    }

    void drawFigure(int i, int j, int fieldWidth) {
        int x = this._boardXMargin;
        int y = this._boardYMargin;
        Board actualBoard = !this._boardEditMode ? Judge.getBoard() : Board.getPreset();
        if (!actualBoard._board[i][j].empty) {
            if (actualBoard._board[i][j].king) {
                if (actualBoard._board[i][j].white) {
                    this.addKingCircle((float)x + (float)((double)j + 0.1) * (float)fieldWidth, (float)y + (float)((double)i + 0.1) * (float)fieldWidth, (float)((double)fieldWidth * 0.8), Figure._playerWhite, this._figures);
                } else {
                    this.addKingCircle((float)x + (float)((double)j + 0.1) * (float)fieldWidth, (float)y + (float)((double)i + 0.1) * (float)fieldWidth, (float)((double)fieldWidth * 0.8), Figure._playerBlack, this._figures);
                }
            } else if (actualBoard._board[i][j].white) {
                this.addFilledCircle((float)x + (float)((double)j + 0.1) * (float)fieldWidth, (float)y + (float)((double)i + 0.1) * (float)fieldWidth, (float)((double)fieldWidth * 0.8), Figure._playerWhite, this._figures);
            } else {
                this.addFilledCircle((float)x + (float)((double)j + 0.1) * (float)fieldWidth, (float)y + (float)((double)i + 0.1) * (float)fieldWidth, (float)((double)fieldWidth * 0.8), Figure._playerBlack, this._figures);
            }
        }
    }

    void drawFigures(int boardWidth) {
        this._boardWidth = boardWidth;
        this.drawFigures();
    }

    void drawFigures() {
        int boardSize = Judge.getBoard().getSize();
        int fieldWidth = this._boardWidth / boardSize;
        for (int i = 0; i < boardSize; ++i) {
            for (int j = (i + 1) % 2; j < boardSize; j += 2) {
                this.drawFigure(i, j, fieldWidth);
            }
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (Figure f : this._board) {
            f.paint(g);
        }
        for (Figure f : this._figures) {
            f.paint(g);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
        this._mouseX = e.getX();
        this._mouseY = e.getY();
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        this._mouseX = e.getX();
        this._mouseY = e.getY();
        int px = e.getX();
        int py = e.getY();
        if (!this.getBoardEditMode()) {
            for (Figure f : this._figures) {
                if (!f.isIn(px, py)) continue;
                f.setSelected(true);
                break;
            }
        } else {
            int fieldWidth = this._boardWidth / Judge.getBoard().getSize();
            int xIndex = (e.getX() - this._boardXMargin) / fieldWidth;
            int yIndex = (e.getY() - this._boardYMargin) / fieldWidth;
            if (xIndex < Judge.getBoard().getSize() && yIndex < Judge.getBoard().getSize() && e.getX() >= this._boardXMargin && e.getY() >= this._boardYMargin) {
                int button = e.getButton();
                if (button == 1) {
                    Board.setPresetField(yIndex, xIndex, true, false);
                } else if (button == 2) {
                    Board.setPresetField(yIndex, xIndex, false, false);
                } else if (button == 3) {
                    Board.setPresetField(yIndex, xIndex, false, true);
                }
            }
            this.totalRepaint();
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (!this.getBoardEditMode()) {
            int fieldWidth = this._boardWidth / Judge.getBoard().getSize();
            int xIndex = (e.getX() - this._boardXMargin) / fieldWidth;
            int yIndex = (e.getY() - this._boardYMargin) / fieldWidth;
            int oldXIndex = (this._mouseX - this._boardXMargin) / fieldWidth;
            int oldYIndex = (this._mouseY - this._boardYMargin) / fieldWidth;
            for (Figure f : this._figures) {
                if (!f.getSelected()) continue;
                if (xIndex < Judge.getBoard().getSize() && yIndex < Judge.getBoard().getSize() && e.getX() >= this._boardXMargin && e.getY() >= this._boardYMargin) {
                    if (Judge.moveValidation(oldYIndex, oldXIndex, yIndex, xIndex)) {
                        this._figures.clear();
                        this.drawFigures();
                        break;
                    }
                    f.setSelected(false);
                    break;
                }
                f.setSelected(false);
                break;
            }
            this.totalRepaint();
            this._mouseX = e.getX();
            this._mouseY = e.getY();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.getBoardEditMode()) {
            for (Figure f : this._figures) {
                if (!f.getSelected()) continue;
                f.move(e.getX() - this._mouseX, e.getY() - this._mouseY);
            }
            this.totalRepaint();
            this._mouseX = e.getX();
            this._mouseY = e.getY();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

