/*
 * Decompiled with CFR 0.152.
 */
package checkers;

import checkers.Board;
import checkers.GUI;
import checkers.Mutex;
import checkers.Piece;
import checkers.Player;
import checkers.PlayerAI;
import checkers.PlayerHuman;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Judge
implements Runnable {
    private static int _drawLimit = 25;
    private static int _drawCounter = 0;
    private static final Mutex _drawMutex = new Mutex();
    private static int _activeThreads = 0;
    private static final Mutex _activeThreadsMutex = new Mutex();
    private static String _log = new String();
    private static final Mutex _logMutex = new Mutex();
    private static final Mutex _guiMutex = new Mutex();
    public static GUI _gui;
    private static final int WHITE_PLAYER = 0;
    private static final int BLACK_PLAYER = 1;
    private static int _boardSize;
    private static int _filledRows;
    private static int _randSeed;
    private static final Mutex _randMutex;
    private static Random _rand;
    private static int _numberOfTests;
    private static Player[] _players;
    private static Board _gameBoard;
    private static final Mutex _gameBoardMutex;
    private static boolean _movesWhite;
    private static final Mutex _movesWhiteMutex;
    private static boolean _endOfGame;
    private static final Mutex _endOfGameMutex;
    private static int _gameNumber;
    private static final Mutex _gameNumberMutex;
    private static boolean _capturing;
    private static final Mutex _capturingMutex;
    private static int _x;
    private static int _y;
    private static final Mutex _boardParamsMutex;
    private static int _sleepTime;
    private static final Mutex _sleepTimeMutex;
    private static boolean _endGameFlag;
    private static final Mutex _endGameFlagMutex;
    private static boolean _testHeuristicMode;
    private static final Mutex _testHeuristicModeMutex;
    private static int _testNo;
    private static final Mutex _testNoMutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTestNo() {
        Mutex mutex = _testNoMutex;
        synchronized (mutex) {
            _testNo = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseTestNo() {
        Mutex mutex = _testNoMutex;
        synchronized (mutex) {
            ++_testNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTestNo() {
        int retval;
        Mutex mutex = _testNoMutex;
        synchronized (mutex) {
            retval = _testNo;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestHeuristicMode(boolean state) {
        Mutex mutex = _testHeuristicModeMutex;
        synchronized (mutex) {
            _testHeuristicMode = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getTestHeuristicMode() {
        boolean retval;
        Mutex mutex = _testHeuristicModeMutex;
        synchronized (mutex) {
            retval = _testHeuristicMode;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEndGameFlag(boolean state) {
        Mutex mutex = _endGameFlagMutex;
        synchronized (mutex) {
            _endGameFlag = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEndGameFlag() {
        boolean retval;
        Mutex mutex = _endGameFlagMutex;
        synchronized (mutex) {
            retval = _endGameFlag;
        }
        return retval;
    }

    public static boolean getPauseFlag() {
        return PlayerAI.getPauseFlag();
    }

    public static void setPauseFlag(boolean state) {
        PlayerAI.setPauseFlag(state);
    }

    public static void switchPauseFlag() {
        PlayerAI.switchPauseFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDrawLimit(int limit) {
        Mutex mutex = _drawMutex;
        synchronized (mutex) {
            _drawLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDrawLimit() {
        int retval;
        Mutex mutex = _drawMutex;
        synchronized (mutex) {
            retval = _drawLimit;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDrawCounter() {
        Mutex mutex = _drawMutex;
        synchronized (mutex) {
            _drawCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseDrawCounter() {
        Mutex mutex = _drawMutex;
        synchronized (mutex) {
            ++_drawCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDrawCounter() {
        int retval;
        Mutex mutex = _drawMutex;
        synchronized (mutex) {
            retval = _drawCounter;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSleepTime(int sleepTime) {
        if (sleepTime >= 0) {
            Mutex mutex = _sleepTimeMutex;
            synchronized (mutex) {
                _sleepTime = sleepTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSleepTime() {
        int retval;
        Mutex mutex = _sleepTimeMutex;
        synchronized (mutex) {
            retval = _sleepTime;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseGameNumber() {
        Mutex mutex = _gameNumberMutex;
        synchronized (mutex) {
            ++_gameNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getGameNumber() {
        int retval;
        Mutex mutex = _gameNumberMutex;
        synchronized (mutex) {
            retval = _gameNumber;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActiveThreads() {
        Mutex mutex = _activeThreadsMutex;
        synchronized (mutex) {
            ++_activeThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reductActiveThreads() {
        Mutex mutex = _activeThreadsMutex;
        synchronized (mutex) {
            --_activeThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveThreads() {
        int retval;
        Mutex mutex = _activeThreadsMutex;
        synchronized (mutex) {
            retval = _activeThreads;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextDouble() {
        double retval;
        Mutex mutex = _randMutex;
        synchronized (mutex) {
            retval = _rand.nextDouble();
        }
        return retval;
    }

    public static int getNumberOfTests() {
        return _numberOfTests;
    }

    public static void setNumberOfTests(int number) {
        _numberOfTests = number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRandSeed() {
        int retval;
        Mutex mutex = _randMutex;
        synchronized (mutex) {
            retval = _randSeed;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRandSeed(int randSeed) {
        Mutex mutex = _randMutex;
        synchronized (mutex) {
            _randSeed = randSeed;
            _rand = new Random(randSeed);
        }
    }

    public static void drawNewRandSeed() {
        Random tmp = new Random();
        int nextSeed = Math.abs(tmp.nextInt()) % 1000000;
        Judge.setRandSeed(nextSeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLog() {
        String retval;
        Mutex mutex = _logMutex;
        synchronized (mutex) {
            retval = new String(_log);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLog(String anotherString) {
        if (_gui == null) {
            return;
        }
        Mutex mutex = _logMutex;
        synchronized (mutex) {
            _log = new String(anotherString);
        }
        mutex = _guiMutex;
        synchronized (mutex) {
            _gui.appendLog(_log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLog() {
        Mutex mutex = _logMutex;
        synchronized (mutex) {
            _log = new String();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBoardSize(int size) {
        Mutex mutex = _boardParamsMutex;
        synchronized (mutex) {
            _boardSize = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFilledRows(int rows) {
        Mutex mutex = _boardParamsMutex;
        synchronized (mutex) {
            _filledRows = rows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBoardSize() {
        int retval;
        Mutex mutex = _boardParamsMutex;
        synchronized (mutex) {
            retval = _boardSize;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFilledRows() {
        int retval;
        Mutex mutex = _boardParamsMutex;
        synchronized (mutex) {
            retval = _filledRows;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getX() {
        int retval;
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            retval = _x;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getY() {
        int retval;
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            retval = _y;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setX(int x) {
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            _x = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setY(int y) {
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            _y = y;
        }
    }

    private static void setCapturingPiece(int x, int y) {
        Judge.setX(x);
        Judge.setY(y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCapturing(boolean capturing) {
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            _capturing = capturing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getCapturing() {
        boolean retval;
        Mutex mutex = _capturingMutex;
        synchronized (mutex) {
            retval = _capturing;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setEndOfGame(boolean state) {
        Mutex mutex = _endOfGameMutex;
        synchronized (mutex) {
            _endOfGame = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEndOfGame() {
        boolean retval;
        Mutex mutex = _endOfGameMutex;
        synchronized (mutex) {
            retval = _endOfGame;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getMovesWhite() {
        boolean retval;
        Mutex mutex = _movesWhiteMutex;
        synchronized (mutex) {
            retval = _movesWhite;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMovesWhite(boolean movesWhite) {
        Mutex mutex = _movesWhiteMutex;
        synchronized (mutex) {
            _movesWhite = movesWhite;
        }
        mutex = _gameBoardMutex;
        synchronized (mutex) {
            _gameBoard.setMovesWhite(movesWhite);
        }
    }

    public static boolean isNowMovingAHuman() {
        if (_players[0] == null || _players[1] == null) {
            return true;
        }
        return Judge.getMovesWhite() && _players[0].GetIAmAHuman() || !Judge.getMovesWhite() && _players[1].GetIAmAHuman();
    }

    private static void moveToLog(Board gameBoard, Board newBoard) {
        int j;
        int i;
        if (_gui == null) {
            return;
        }
        String log = new String();
        int k = -1;
        int l = -1;
        for (i = 0; i < gameBoard.getSize(); ++i) {
            for (j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (gameBoard._board[i][j].empty || !newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                log = gameBoard.getMovesWhite() ? log + Judge._gui._msg.getString("UpperPlayerYellow") : log + Judge._gui._msg.getString("UpperLowerRed");
                log = log + " (" + i + "," + j + ") --> ";
                k = i;
                l = j;
            }
        }
        for (i = 0; i < gameBoard.getSize(); ++i) {
            for (j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty || newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                log = log + "(" + i + "," + j + ")";
                log = Math.abs(k - i) == 2 && Math.abs(l - j) == 2 ? log + Judge._gui._msg.getString("CAPTURING") : log + "\n";
            }
        }
        if (k >= 0 && l >= 0) {
            Judge.updateLog(log);
        }
    }

    private static boolean wasItKingsMove(Board gameBoard, Board newBoard) {
        int j;
        int i;
        int kingsBefore = 0;
        int kingsAfter = 0;
        int piecesBefore = 0;
        int piecesAfter = 0;
        for (i = 0; i < gameBoard.getSize(); ++i) {
            for (j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty) {
                    ++piecesBefore;
                }
                if (!newBoard._board[i][j].empty) {
                    ++piecesAfter;
                }
                if (!gameBoard._board[i][j].empty && gameBoard._board[i][j].king) {
                    ++kingsBefore;
                }
                if (newBoard._board[i][j].empty || !newBoard._board[i][j].king) continue;
                ++kingsAfter;
            }
        }
        if (kingsBefore != kingsAfter) {
            return false;
        }
        if (piecesBefore != piecesAfter) {
            return false;
        }
        for (i = 0; i < gameBoard.getSize(); ++i) {
            for (j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty || newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                return newBoard._board[i][j].king;
            }
        }
        return false;
    }

    private static void findCapturingMove(Board gameBoard, Board newBoard) {
        for (int i = 0; i < gameBoard.getSize(); ++i) {
            for (int j = (i + 1) % 2; j < gameBoard.getSize(); j += 2) {
                if (!gameBoard._board[i][j].empty || newBoard._board[i][j].empty || newBoard._board[i][j].white != gameBoard.getMovesWhite()) continue;
                Judge.setCapturingPiece(i, j);
                return;
            }
        }
    }

    Judge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Board getBoard() {
        Board boardClone;
        Mutex mutex = _gameBoardMutex;
        synchronized (mutex) {
            boardClone = new Board(_gameBoard);
        }
        return boardClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareBoard() {
        boolean retval;
        Mutex mutex = _gameBoardMutex;
        synchronized (mutex) {
            _gameBoard = new Board(Judge.getBoardSize(), Judge.getFilledRows());
            retval = _gameBoard.prepareBoard();
        }
        return retval;
    }

    public static void setPlayer(boolean color, boolean ai) {
        if (color) {
            Judge._players[0] = ai ? new PlayerAI(color) : new PlayerHuman(color);
        } else {
            Judge._players[1] = ai ? new PlayerAI(color) : new PlayerHuman(color);
        }
    }

    public static void setPlayer(boolean color, boolean ai, String className) {
        if (color) {
            Judge._players[0] = ai ? new PlayerAI(color, className) : new PlayerHuman(color);
        } else {
            Judge._players[1] = ai ? new PlayerAI(color, className) : new PlayerHuman(color);
        }
    }

    public static ArrayList<Board> availableMoves(Board boardToAnalize) {
        boolean capturing = false;
        ArrayList<Board> retval = new ArrayList<Board>();
        for (int i = 0; i < boardToAnalize.getSize(); ++i) {
            for (int j = (i + 1) % 2; j < boardToAnalize.getSize(); j += 2) {
                if (boardToAnalize._board[i][j].empty || boardToAnalize._board[i][j].white != boardToAnalize.getMovesWhite()) continue;
                for (int k = -1; k < 2; k += 2) {
                    for (int l = -1; l < 2; l += 2) {
                        Board board;
                        if (i + k >= boardToAnalize.getSize() || i + k < 0 || j + l >= boardToAnalize.getSize() || j + l < 0) continue;
                        if (!capturing && boardToAnalize._board[i + k][j + l].empty) {
                            if (!boardToAnalize._board[i][j].king && (boardToAnalize._board[i][j].king || !boardToAnalize._board[i][j].white || k <= 0) && (boardToAnalize._board[i][j].white || k >= 0)) continue;
                            board = new Board(boardToAnalize);
                            board.setMovesWhite(!boardToAnalize.getMovesWhite());
                            Judge.moveFigure(board, i, j, i + k, j + l);
                            retval.add(board);
                            continue;
                        }
                        if (boardToAnalize._board[i + k][j + l].empty || boardToAnalize._board[i + k][j + l].white == boardToAnalize.getMovesWhite() || i + 2 * k >= boardToAnalize.getSize() || i + 2 * k < 0 || j + 2 * l >= boardToAnalize.getSize() || j + 2 * l < 0 || !boardToAnalize._board[i][j].king && (boardToAnalize._board[i][j].king || !boardToAnalize._board[i][j].white || k <= 0) && (boardToAnalize._board[i][j].white || k >= 0) || !boardToAnalize._board[i + 2 * k][j + 2 * l].empty) continue;
                        if (!capturing) {
                            retval.clear();
                        }
                        capturing = true;
                        board = new Board(boardToAnalize);
                        board.setMovesWhite(!boardToAnalize.getMovesWhite());
                        Judge.moveFigure(board, i, j, i + 2 * k, j + 2 * l);
                        board._board[i + k][j + l].empty = true;
                        if (boardToAnalize._board[i][j].king || !board._board[i + 2 * k][j + 2 * l].king) {
                            for (int m = -1; m < 2; m += 2) {
                                for (int n = -1; n < 2; n += 2) {
                                    if (i + 2 * k + 2 * m >= boardToAnalize.getSize() || i + 2 * k + 2 * m < 0 || j + 2 * l + 2 * n >= boardToAnalize.getSize() || j + 2 * l + 2 * n < 0 || !board._board[i + 2 * k + 2 * m][j + 2 * l + 2 * n].empty || board._board[i + 2 * k + m][j + 2 * l + n].empty || board._board[i + 2 * k + m][j + 2 * l + n].white == boardToAnalize.getMovesWhite() || !board._board[i + 2 * k][j + 2 * l].king && (board._board[i + 2 * k][j + 2 * l].king || !board._board[i + 2 * k][j + 2 * l].white || m <= 0) && (board._board[i + 2 * k][j + 2 * l].white || m >= 0)) continue;
                                    board.setMovesWhite(boardToAnalize.getMovesWhite());
                                }
                            }
                        }
                        retval.add(board);
                    }
                }
            }
        }
        return retval;
    }

    public static void moveFigure(Board b, int x, int y, int newX, int newY) {
        Judge.moveFigure(b._board, x, y, newX, newY, b.getSize());
    }

    public static void moveFigure(Piece[][] b, int x, int y, int newX, int newY, int size) {
        int minX = Math.min(x, newX);
        int minY = Math.min(y, newY);
        int xMod = x == minX ? 1 : -1;
        int yMod = y == minY ? 1 : -1;
        if (Math.abs(newX - x) == Math.abs(newY - y)) {
            for (int i = 0; i < Math.abs(x - newX); ++i) {
                if (b[x + xMod * i][y + yMod * i] == null) continue;
                b[x + xMod * i][y + yMod * i].empty = true;
            }
        }
        b[newX][newY].empty = false;
        b[newX][newY].white = b[x][y].white;
        b[newX][newY].king = b[x][y].king;
        if (b[newX][newY].white && newX == size - 1) {
            b[newX][newY].king = true;
        }
        if (!b[newX][newY].white && newX == 0) {
            b[newX][newY].king = true;
        }
    }

    public static boolean moveValidation(int x, int y, int newX, int newY) {
        boolean retval = false;
        if (Judge.isNowMovingAHuman()) {
            Piece[][] board = Judge._gameBoard._board;
            if (board[x][y].white == Judge.getMovesWhite() && board[newX][newY] != null && board[newX][newY].empty) {
                ArrayList<Board> moves = Judge.availableMoves(_gameBoard);
                Board tmpBoard = new Board(_gameBoard);
                Judge.moveFigure(tmpBoard, x, y, newX, newY);
                for (Board b : moves) {
                    if (!tmpBoard.isEqual(b) || Judge.getCapturing() && !b._board[Judge.getX()][Judge.getY()].empty) continue;
                    if (_gameBoard.getMovesWhite() == b.getMovesWhite()) {
                        Judge.findCapturingMove(_gameBoard, tmpBoard);
                        Judge.setCapturing(true);
                    } else {
                        Judge.setCapturing(false);
                        if (Judge.wasItKingsMove(_gameBoard, tmpBoard)) {
                            Judge.increaseDrawCounter();
                        } else {
                            Judge.resetDrawCounter();
                        }
                    }
                    Judge.moveToLog(_gameBoard, tmpBoard);
                    Judge.moveFigure(_gameBoard, x, y, newX, newY);
                    boolean tmpMovesWhite = b.getMovesWhite();
                    ArrayList<Board> nextMoves = Judge.availableMoves(b);
                    if (nextMoves.isEmpty()) {
                        if (!tmpMovesWhite) {
                            if (_gui != null) {
                                Judge.updateLog(Judge._gui._msg.getString("UpperPlayerWins"));
                                _gui.addToUpperScore();
                            } else {
                                System.out.print(1);
                            }
                        } else if (_gui != null) {
                            Judge.updateLog(Judge._gui._msg.getString("LowerPlayerWins"));
                            _gui.addToLowerScore();
                        } else {
                            System.out.print(-1);
                        }
                        Judge.setEndOfGame(true);
                    } else if (Judge.getDrawCounter() >= Judge.getDrawLimit()) {
                        if (_gui != null) {
                            Judge.updateLog(Judge._gui._msg.getString("Draw"));
                            _gui.addToDrawScore();
                        } else {
                            System.out.print(0);
                        }
                        Judge.setEndOfGame(true);
                    }
                    retval = true;
                    Judge.setMovesWhite(tmpMovesWhite);
                    _gameBoard.setMovesWhite(tmpMovesWhite);
                    break;
                }
            }
        } else if (_gui != null) {
            Judge.updateLog(Judge._gui._msg.getString("Relax"));
        }
        return retval;
    }

    public static boolean makeAIMove() {
        boolean retval = false;
        if (!Judge.isNowMovingAHuman()) {
            ArrayList<Board> nextMoves = Judge.availableMoves(_gameBoard);
            Board newBoard = new Board(_gameBoard);
            if (!Judge.isNowMovingAHuman()) {
                if (Judge.getMovesWhite() && !_players[0].GetIAmAHuman()) {
                    newBoard = _players[0].chooseMove(_gameBoard);
                } else if (!Judge.getMovesWhite() && !_players[1].GetIAmAHuman()) {
                    newBoard = _players[1].chooseMove(_gameBoard);
                }
                if (!Judge.getEndOfGame()) {
                    for (Board b : nextMoves) {
                        if (!b.isEqual(newBoard) || Judge.getCapturing() && !b._board[Judge.getX()][Judge.getY()].empty) continue;
                        if (_gameBoard.getMovesWhite() == newBoard.getMovesWhite()) {
                            Judge.findCapturingMove(_gameBoard, newBoard);
                            Judge.setCapturing(true);
                        } else {
                            Judge.setCapturing(false);
                            if (Judge.wasItKingsMove(_gameBoard, newBoard)) {
                                Judge.increaseDrawCounter();
                            } else {
                                Judge.resetDrawCounter();
                            }
                        }
                        Judge.moveToLog(_gameBoard, newBoard);
                        _gameBoard = newBoard;
                        Judge.setMovesWhite(newBoard.getMovesWhite());
                        ArrayList<Board> moves = Judge.availableMoves(newBoard);
                        if (moves.isEmpty()) {
                            if (!Judge.getMovesWhite()) {
                                if (_gui != null) {
                                    Judge.updateLog(Judge._gui._msg.getString("UpperPlayerWins"));
                                    _gui.addToUpperScore();
                                } else {
                                    System.out.print(1);
                                }
                            } else if (_gui != null) {
                                Judge.updateLog(Judge._gui._msg.getString("LowerPlayerWins"));
                                _gui.addToLowerScore();
                            } else {
                                System.out.print(-1);
                            }
                            Judge.setEndOfGame(true);
                        } else if (Judge.getDrawCounter() >= Judge.getDrawLimit()) {
                            if (_gui != null) {
                                Judge.updateLog(Judge._gui._msg.getString("Draw"));
                                _gui.addToDrawScore();
                            } else {
                                System.out.print(0);
                            }
                            Judge.setEndOfGame(true);
                        }
                        retval = true;
                        break;
                    }
                }
            }
        }
        return retval;
    }

    public static boolean endGame() {
        Judge.setEndOfGame(true);
        return true;
    }

    public static void startGame() {
        Judge.setEndOfGame(true);
        Judge.increaseGameNumber();
        Judge judge = new Judge();
        Thread judgeThread = new Thread(judge);
        judgeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Mutex ex2;
        Judge.addActiveThreads();
        int currentAILevel = PlayerAI.getLevel();
        PlayerAI.setLevel(1);
        boolean pauseFlag = Judge.getPauseFlag();
        Judge.setPauseFlag(false);
        while (Judge.getActiveThreads() != 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex2) {
                Logger.getLogger(Judge.class.getName()).log(Level.SEVERE, null, ex2);
            }
        }
        PlayerAI.setLevel(currentAILevel);
        int myNumber = Judge.getGameNumber();
        Judge.setCapturing(false);
        PlayerAI.setCapturing(false);
        if (_gui != null) {
            _gui.randSeedInternalChangedMessage();
        }
        Judge.prepareBoard();
        if (_gui != null) {
            ex2 = _guiMutex;
            synchronized (ex2) {
                Judge._gui._window.drawBoard();
                _gui.totalRepaint();
            }
        }
        Judge.clearLog();
        Judge.setEndOfGame(false);
        Judge.resetDrawCounter();
        if (_gameBoard.getSize() == 2) {
            if (_gui != null) {
                Judge.updateLog(Judge._gui._msg.getString("LowerPlayerWins"));
            } else {
                System.out.print(-1);
            }
            Judge.setEndOfGame(true);
        }
        Judge.setPauseFlag(pauseFlag);
        while (!Judge.getEndOfGame()) {
            int actualNumber;
            if (Judge.getMovesWhite() && !_players[0].GetIAmAHuman() && (actualNumber = Judge.getGameNumber()) == myNumber) {
                if (Judge.getEndOfGame() || !Judge.makeAIMove()) break;
                if (_gui != null) {
                    ex2 = _guiMutex;
                    synchronized (ex2) {
                        _gui.totalRepaint();
                    }
                }
            }
            if (_gui != null) {
                try {
                    Thread.sleep(Judge.getSleepTime());
                }
                catch (InterruptedException ex3) {
                    Logger.getLogger(Judge.class.getName()).log(Level.SEVERE, null, ex3);
                }
            }
            if (!Judge.getMovesWhite() && !_players[1].GetIAmAHuman() && (actualNumber = Judge.getGameNumber()) == myNumber) {
                if (Judge.getEndOfGame() || !Judge.makeAIMove()) break;
                if (_gui != null) {
                    ex2 = _guiMutex;
                    synchronized (ex2) {
                        _gui.totalRepaint();
                    }
                }
            }
            if (_gui == null) continue;
            try {
                Thread.sleep(Judge.getSleepTime());
            }
            catch (InterruptedException ex4) {
                Logger.getLogger(Judge.class.getName()).log(Level.SEVERE, null, ex4);
            }
        }
        Judge.setMovesWhite(true);
        Judge.reductActiveThreads();
    }

    static {
        _boardSize = 8;
        _filledRows = 3;
        _randSeed = 13;
        _randMutex = new Mutex();
        _rand = new Random(13L);
        _numberOfTests = 1;
        _players = new Player[2];
        _gameBoard = new Board(8, 3);
        _gameBoardMutex = new Mutex();
        _movesWhite = true;
        _movesWhiteMutex = new Mutex();
        _endOfGame = true;
        _endOfGameMutex = new Mutex();
        _gameNumber = 0;
        _gameNumberMutex = new Mutex();
        _capturing = false;
        _capturingMutex = new Mutex();
        _x = 0;
        _y = 0;
        _boardParamsMutex = new Mutex();
        _sleepTime = 100;
        _sleepTimeMutex = new Mutex();
        _endGameFlagMutex = new Mutex();
        _testHeuristicMode = false;
        _testHeuristicModeMutex = new Mutex();
        _testNo = 1;
        _testNoMutex = new Mutex();
    }
}

