#include "demo2.h"

KNIGHT_::KNIGHT_(KNODE_ *start, KNODE_ *target)
    : BREADTH_GRAPH_(start, target, 8)
{
}


KNODE_::KNODE_(int pos1, int pos2)
{
    x = pos1;
    y = pos2;
}


void KNODE_::display() const
{
    printf("%d/%d\n", x, y);   // display x- and y-coordinates of position
}


int KNODE_::equal(const VOBJECT_ &other) const
{
    return(x == ((const KNODE_ &)other).get_x()
           && y == ((const KNODE_ &)other).get_y());
}


int KNODE_::get_x() const
{
    return(x);
}


int KNODE_::get_y() const
{
    return(y);
}


NODE_ *KNODE_::do_operator(int op) const
{
    int
        new_x, new_y;

    switch(op)		// we keep it simple here...
    {
        case 0:
            new_x = x + 2;
            new_y = y + 1;
            break;
        case 1:
            new_x = x + 2;
            new_y = y - 1;
            break;
        case 2:
            new_x = x - 2;
            new_y = y + 1;
            break;
        case 3:
            new_x = x - 2;
            new_y = y - 1;
            break;
        case 4:
            new_x = x + 1;
            new_y = y + 2;
            break;
        case 5:
            new_x = x - 1;
            new_y = y + 2;
        case 6:
            new_x = x + 1;
            new_y = y - 2;
        default:
            new_x = x - 1;
            new_y = y - 2;
    }
    return(( new_x > 0 && new_x < 9 && new_y > 0 && new_y < 9) ?
            new KNODE_(new_x, new_y) : NULL);
}


int main()
{
    KNIGHT_
        knight(new KNODE_(1, 1), new KNODE_(3, 3));

    knight.generate();
    return(1);
}

