/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Prolog;
import alice.tuprologx.ide.AWTFrameLauncher;
import alice.tuprologx.ide.DotNetEditArea;
import alice.tuprologx.ide.DotNetIOManager;
import alice.tuprologx.ide.DotNetInputField;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.LibraryDialog;
import alice.tuprologx.ide.LibraryManager;
import alice.tuprologx.ide.ThinletConsole;
import alice.tuprologx.ide.ThinletDebugArea;
import alice.tuprologx.ide.ThinletStatusBar;
import alice.tuprologx.ide.ThinletTheoryEditor;
import alice.tuprologx.ide.ThinletToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class DotNetIDE
extends Frame
implements IDE {
    private ThinletTheoryEditor editor;
    private DotNetEditArea editArea;
    private ThinletToolBar toolBar;

    public DotNetIDE() {
        super("tuProlog IDE");
        this.initComponents();
    }

    private void initComponents() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Prolog prolog = new Prolog();
        System.out.println("tuProlog system - release " + Prolog.getVersion());
        ThinletDebugArea thinletDebugArea = new ThinletDebugArea();
        prolog.addSpyListener(thinletDebugArea);
        ThinletStatusBar thinletStatusBar = new ThinletStatusBar();
        this.editor = new ThinletTheoryEditor();
        this.editor.addPropertyChangeListener(thinletStatusBar);
        panel.add((Component)this.editor, "North");
        this.editArea = new DotNetEditArea();
        this.editor.setEditArea(this.editArea);
        this.editArea.addPropertyChangeListener(this.editor);
        this.editArea.setBackground(new Color(230, 230, 230));
        panel.add((Component)this.editArea, "Center");
        ThinletConsole thinletConsole = new ThinletConsole(this);
        thinletConsole.addPropertyChangeListener(thinletStatusBar);
        thinletConsole.setStatusMessage("Ready.");
        DotNetInputField dotNetInputField = new DotNetInputField();
        thinletConsole.setInputField(dotNetInputField);
        dotNetInputField.setBackground(new Color(230, 230, 230));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        panel2.add((Component)dotNetInputField, gridBagConstraints);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)panel2, "North");
        panel3.add((Component)thinletConsole, "Center");
        panel.add((Component)panel3, "South");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        this.toolBar = new ThinletToolBar(this);
        panel4.add((Component)this.toolBar, "North");
        panel4.add((Component)panel, "Center");
        this.toolBar.addPropertyChangeListener(thinletStatusBar);
        this.toolBar.setDebugArea(thinletDebugArea);
        this.toolBar.setFileManager(new DotNetIOManager(this));
        AWTFrameLauncher aWTFrameLauncher = new AWTFrameLauncher();
        aWTFrameLauncher.setFrameIcon("tuProlog.gif");
        this.toolBar.setFrameLauncher(aWTFrameLauncher);
        panel4.add((Component)thinletStatusBar, "South");
        LibraryManager libraryManager = new LibraryManager();
        libraryManager.setEngine(prolog);
        LibraryDialog libraryDialog = new LibraryDialog(libraryManager);
        prolog.addLibraryListener(libraryDialog);
        this.toolBar.setLibraryDialog(libraryDialog);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.add(panel4);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("tuProlog.gif")));
    }

    public void enableTheoryCommands(boolean bl) {
        this.editor.enableTheoryCommands(bl);
        this.toolBar.enableTheoryCommands(bl);
    }

    public boolean isFeededTheory() {
        return !this.editArea.isDirty();
    }

    public void setFeededTheory(boolean bl) {
        this.editArea.setDirty(!bl);
    }

    public String getEditorContent() {
        return this.editArea.getTheory();
    }

    public void setEditorContent(String string) {
        this.editArea.setTheory(string);
    }
}

