/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.tcp;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprologx.runtime.tcp.Daemon;
import alice.tuprologx.runtime.tcp.NetMsg;
import alice.tuprologx.runtime.tcp.Prolog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class Proxy
implements Prolog {
    Socket socket;
    ObjectOutputStream out;
    ObjectInputStream in;

    public Proxy(String string) throws UnknownHostException, IOException {
        this.socket = new Socket(string, Daemon.DEFAULT_PORT);
        this.out = new ObjectOutputStream(this.socket.getOutputStream());
        this.in = new ObjectInputStream(this.socket.getInputStream());
    }

    public Proxy(String string, int n) throws UnknownHostException, IOException {
        this.socket = new Socket(string, n);
        this.out = new ObjectOutputStream(this.socket.getOutputStream());
        this.in = new ObjectInputStream(this.socket.getInputStream());
    }

    public void clearTheory() throws Exception {
        this.out.writeObject(new NetMsg("clearTheory"));
        this.out.flush();
    }

    public Theory getTheory() throws Exception {
        this.out.writeObject(new NetMsg("getTheory"));
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (bl.booleanValue()) {
            Theory theory = (Theory)this.in.readObject();
            return theory;
        }
        return null;
    }

    public void setTheory(Theory theory) throws Exception {
        this.out.writeObject(new NetMsg("setTheory"));
        this.out.writeObject(theory);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (!bl.booleanValue()) {
            throw new InvalidTheoryException();
        }
    }

    public void addTheory(Theory theory) throws Exception {
        this.out.writeObject(new NetMsg("addTheory"));
        this.out.writeObject(theory);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (!bl.booleanValue()) {
            throw new InvalidTheoryException();
        }
    }

    public SolveInfo solve(String string) throws Exception {
        this.out.writeObject(new NetMsg("solveString"));
        this.out.writeObject(string);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (bl.booleanValue()) {
            SolveInfo solveInfo = (SolveInfo)this.in.readObject();
            return solveInfo;
        }
        throw new MalformedGoalException();
    }

    public SolveInfo solve(Term term) throws Exception {
        this.out.writeObject(new NetMsg("solveTerm"));
        this.out.writeObject(term);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (bl.booleanValue()) {
            SolveInfo solveInfo = (SolveInfo)this.in.readObject();
            return solveInfo;
        }
        throw new MalformedGoalException();
    }

    public SolveInfo solveNext() throws Exception {
        this.out.writeObject(new NetMsg("solveNext"));
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (bl.booleanValue()) {
            SolveInfo solveInfo = (SolveInfo)this.in.readObject();
            return solveInfo;
        }
        throw new NoSolutionException();
    }

    public boolean hasOpenAlternatives() throws Exception {
        this.out.writeObject(new NetMsg("hasOpenAlternatives"));
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        return bl;
    }

    public void solveHalt() throws Exception {
        this.out.writeObject(new NetMsg("solveHalt"));
        this.out.flush();
    }

    public void solveEnd() throws Exception {
        this.out.writeObject(new NetMsg("solveEnd"));
        this.out.flush();
    }

    public void loadLibrary(String string) throws Exception {
        this.out.writeObject(new NetMsg("loadLibrary"));
        this.out.writeObject(string);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (!bl.booleanValue()) {
            throw new InvalidLibraryException();
        }
    }

    public void unloadLibrary(String string) throws Exception {
        this.out.writeObject(new NetMsg("unloadLibrary"));
        this.out.writeObject(string);
        this.out.flush();
        Boolean bl = (Boolean)this.in.readObject();
        if (!bl.booleanValue()) {
            throw new InvalidLibraryException();
        }
    }
}

