/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.AbstractSubGoalTree;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Struct;
import alice.tuprolog.SubGoalElement;
import alice.tuprolog.SubGoalTree;
import alice.tuprolog.Term;
import java.util.AbstractMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ClauseInfo {
    private Struct clause;
    private Struct head;
    private SubGoalTree body;
    private Struct headCopy;
    private SubGoalTree bodyCopy;
    String libName;

    ClauseInfo(Struct struct, String string) {
        this.clause = struct;
        this.head = this.extractHead(this.clause);
        this.body = ClauseInfo.extractBody(this.clause.getArg(1));
        this.libName = string;
    }

    private Struct extractHead(Struct struct) {
        return (Struct)struct.getArg(0);
    }

    static SubGoalTree extractBody(Term term) {
        SubGoalTree subGoalTree = new SubGoalTree();
        ClauseInfo.extractBody(subGoalTree, term);
        return subGoalTree;
    }

    private static void extractBody(SubGoalTree subGoalTree, Term term) {
        while (term instanceof Struct && ((Struct)term).getName().equals(",")) {
            Term term2 = ((Struct)term).getArg(0);
            if (term2 instanceof Struct && ((Struct)term2).getName().equals(",")) {
                ClauseInfo.extractBody(subGoalTree.addChild(), term2);
            } else {
                subGoalTree.addChild(term2);
            }
            term = ((Struct)term).getArg(1);
        }
        subGoalTree.addChild(term);
    }

    public String toString(OperatorManager operatorManager) {
        int n = operatorManager.opPrio(":-", "xfx");
        if (n >= 1) {
            String string = ClauseInfo.indentPredicatesAsArgX(this.clause.getArg(1), operatorManager, n);
            String string2 = this.clause.getArg(0).toStringAsArgX(operatorManager, n);
            if (string.equals("true")) {
                return string2 + ".\n";
            }
            return string2 + " :-\n\t" + string + ".\n";
        }
        n = operatorManager.opPrio(":-", "yfx");
        if (n >= 1) {
            String string = ClauseInfo.indentPredicatesAsArgX(this.clause.getArg(1), operatorManager, n);
            String string3 = this.clause.getArg(0).toStringAsArgY(operatorManager, n);
            if (string.equals("true")) {
                return string3 + ".\n";
            }
            return string3 + " :-\n\t" + string + ".\n";
        }
        n = operatorManager.opPrio(":-", "xfy");
        if (n >= 1) {
            String string = ClauseInfo.indentPredicatesAsArgY(this.clause.getArg(1), operatorManager, n);
            String string4 = this.clause.getArg(0).toStringAsArgX(operatorManager, n);
            if (string.equals("true")) {
                return string4 + ".\n";
            }
            return string4 + " :-\n\t" + string + ".\n";
        }
        return this.clause.toString();
    }

    Struct getClause() {
        return this.clause;
    }

    Struct getHead() {
        return this.head;
    }

    SubGoalTree getBody() {
        return this.body;
    }

    String getLibraryName() {
        return this.libName;
    }

    void performCopy() {
        AbstractMap abstractMap = new LinkedHashMap();
        this.clause = (Struct)this.clause.copy(abstractMap, -1);
        abstractMap = new IdentityHashMap();
        this.head = (Struct)this.head.copy(abstractMap, -1);
        this.body = new SubGoalTree();
        this.bodyCopy(this.body, this.bodyCopy, abstractMap, -1);
    }

    void performCopy(int n) {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        this.headCopy = (Struct)this.head.copy(identityHashMap, n);
        this.bodyCopy = new SubGoalTree();
        this.bodyCopy(this.body, this.bodyCopy, identityHashMap, n);
    }

    private void bodyCopy(SubGoalTree subGoalTree, SubGoalTree subGoalTree2, AbstractMap abstractMap, int n) {
        Iterator iterator = subGoalTree.iterator();
        while (iterator.hasNext()) {
            Object object;
            AbstractSubGoalTree abstractSubGoalTree;
            AbstractSubGoalTree abstractSubGoalTree2 = (AbstractSubGoalTree)iterator.next();
            if (abstractSubGoalTree2.isLeaf()) {
                abstractSubGoalTree = (SubGoalElement)abstractSubGoalTree2;
                object = ((SubGoalElement)abstractSubGoalTree).getValue().copy(abstractMap, n);
                subGoalTree2.addChild((Term)object);
                continue;
            }
            abstractSubGoalTree = (SubGoalTree)abstractSubGoalTree2;
            object = subGoalTree2.addChild();
            this.bodyCopy((SubGoalTree)abstractSubGoalTree, (SubGoalTree)object, abstractMap, n);
        }
    }

    Struct getHeadCopy() {
        return this.headCopy;
    }

    SubGoalTree getBodyCopy() {
        return this.bodyCopy;
    }

    public String toString() {
        String string = ClauseInfo.indentPredicates(this.clause.getArg(1));
        return this.clause.getArg(0).toString() + " :-\n\t" + string + ".\n";
    }

    private static String indentPredicates(Term term) {
        if (term instanceof Struct) {
            Struct struct = (Struct)term;
            if (struct.getName().equals(",")) {
                return struct.getArg(0).toString() + ",\n\t" + ClauseInfo.indentPredicates(struct.getArg(1));
            }
            return term.toString();
        }
        return term.toString();
    }

    private static String indentPredicatesAsArgX(Term term, OperatorManager operatorManager, int n) {
        if (term instanceof Struct) {
            Struct struct = (Struct)term;
            if (struct.getName().equals(",")) {
                return struct.getArg(0).toStringAsArgX(operatorManager, n) + ",\n\t" + "(" + ClauseInfo.indentPredicatesAsArgX(struct.getArg(1), operatorManager, n) + ")";
            }
            return term.toStringAsArgX(operatorManager, n);
        }
        return term.toStringAsArgX(operatorManager, n);
    }

    private static String indentPredicatesAsArgY(Term term, OperatorManager operatorManager, int n) {
        if (term instanceof Struct) {
            Struct struct = (Struct)term;
            if (struct.getName().equals(",")) {
                return struct.getArg(0).toStringAsArgY(operatorManager, n) + ",\n\t" + "(" + ClauseInfo.indentPredicatesAsArgY(struct.getArg(1), operatorManager, n) + ")";
            }
            return term.toStringAsArgY(operatorManager, n);
        }
        return term.toStringAsArgY(operatorManager, n);
    }
}

