/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

class Flag
implements Serializable {
    private String name;
    private Struct valueList;
    private Term value;
    private Term defaultValue;
    private boolean modifiable;
    private String libraryName;

    public Flag(String string, Struct struct, Term term, boolean bl, String string2) {
        this.name = string;
        this.valueList = struct;
        this.defaultValue = term;
        this.modifiable = bl;
        this.libraryName = string2;
        this.value = term;
    }

    protected Flag() {
    }

    public Object clone() {
        Flag flag = new Flag();
        flag.name = this.name;
        flag.valueList = (Struct)this.valueList.copy(new HashMap(), -1);
        flag.value = this.value.copy(new HashMap(), -1);
        flag.defaultValue = this.defaultValue.copy(new HashMap(), -1);
        flag.modifiable = this.modifiable;
        flag.libraryName = this.libraryName;
        return flag;
    }

    public boolean isValidValue(Term term) {
        Iterator iterator = this.valueList.listIterator();
        while (iterator.hasNext()) {
            Term term2 = (Term)iterator.next();
            if (!term.match(term2)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Struct getValueList() {
        return this.valueList;
    }

    public boolean setValue(Term term) {
        if (this.isValidValue(term) && this.modifiable) {
            this.value = term;
            return true;
        }
        return false;
    }

    public Term getValue() {
        return this.value;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public String getLibraryName() {
        return this.libraryName;
    }
}

