/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Parser;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;

public class Theory
implements Serializable {
    private String theory;
    private Struct clauseList;

    public Theory(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        this.theory = new String(byArray);
    }

    public Theory(String string) throws InvalidTheoryException {
        if (string == null) {
            throw new InvalidTheoryException();
        }
        this.theory = string;
    }

    Theory() {
        this.theory = "";
    }

    public Theory(Struct struct) throws InvalidTheoryException {
        if (struct == null || !struct.isList()) {
            throw new InvalidTheoryException();
        }
        this.clauseList = struct;
    }

    public Iterator iterator(Prolog prolog) {
        if (this.isTextual()) {
            return new Parser(prolog.getOperatorManager(), this.theory).iterator();
        }
        return this.clauseList.listIterator();
    }

    public void append(Theory theory) throws InvalidTheoryException {
        if (theory.isTextual() && this.isTextual()) {
            this.theory = this.theory + theory.theory;
        } else if (!theory.isTextual() && !this.isTextual()) {
            Struct struct = theory.getClauseListRepresentation();
            if (this.clauseList.isEmptyList()) {
                this.clauseList = struct;
            } else {
                Struct struct2;
                Struct struct3 = this.clauseList;
                while (!(struct2 = (Struct)struct3.getArg(1)).isEmptyList()) {
                    struct3 = struct2;
                }
                struct3.setArg(1, struct);
            }
        } else if (!this.isTextual() && theory.isTextual()) {
            this.theory = this.theory.toString() + "\n" + theory;
            this.clauseList = null;
        } else if (this.isTextual() && !theory.isTextual()) {
            this.theory = this.theory + theory.toString();
        } else {
            throw new InvalidTheoryException();
        }
    }

    boolean isTextual() {
        return this.theory != null;
    }

    Struct getClauseListRepresentation() {
        return this.clauseList;
    }

    public String toString() {
        return this.theory != null ? this.theory : this.clauseList.toString();
    }
}

