/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.TheoryEditArea;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;

public class DotNetEditArea
extends Panel
implements TheoryEditArea {
    private TextArea textArea = new TextArea(25, 80);
    private Vector table;
    private int caretLine;
    private boolean dirty;
    private PropertyChangeSupport propertyChangeSupport;

    public DotNetEditArea() {
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.dirty = false;
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (!DotNetEditArea.this.dirty) {
                    DotNetEditArea.this.setDirty(true);
                }
                DotNetEditArea.this.inputKeyReleased(keyEvent);
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DotNetEditArea.this.doSetCaretLine();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.textArea, gridBagConstraints);
        this.table = this.buildLengthTable(this.textArea.getText());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public String getTheory() {
        return this.textArea.getText();
    }

    public void setTheory(String string) {
        this.textArea.setText(string);
    }

    public void setCaretLine(int n) {
        int n2 = this.getCaretLine();
        this.caretLine = n;
        this.propertyChangeSupport.firePropertyChange("caretLine", n2, n);
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void undoAction() {
    }

    public void redoAction() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void inputKeyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.isCursorMovement(n)) {
            this.table = this.buildLengthTable(this.textArea.getText());
        }
        this.doSetCaretLine();
    }

    private void doSetCaretLine() {
        int n = this.getCurrentLine(this.textArea.getCaretPosition());
        this.setCaretLine(n);
    }

    private boolean isCursorMovement(int n) {
        switch (n) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private int getCurrentLine(int n) {
        int n2 = (Integer)this.table.get(this.table.size() - 1);
        for (int i = 0; i < this.table.size(); ++i) {
            int n3 = (Integer)this.table.get(i);
            if (n >= n3) continue;
            return i + 1;
        }
        return this.table.size();
    }

    private Vector buildLengthTable(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        int n2 = 0;
        String string2 = string;
        while (string2.indexOf("\n") != -1) {
            int n3 = string2.substring(0, string2.indexOf("\n")).length();
            n2 = n3 == 0 ? ++n2 : (n2 += n3 + 1);
            vector.add(n++, new Integer(n2));
            string2 = string2.substring(string2.indexOf("\n") + 1);
        }
        vector.add(n, new Integer(n2 += string2.length()));
        return vector;
    }
}

