/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.PrologTextArea;
import alice.tuprologx.ide.PrologTokenMarker;
import alice.tuprologx.ide.TheoryEditArea;
import alice.util.jedit.JEditTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JavaEditArea
extends JPanel
implements TheoryEditArea {
    private JEditTextArea inputTheory;
    private int caretLine;
    private boolean dirty;
    private PropertyChangeSupport propertyChangeSupport;
    private UndoManager undoManager;

    public JavaEditArea() {
        PrologTextArea prologTextArea = new PrologTextArea();
        this.setKeyBindings(prologTextArea);
        this.inputTheory = new JEditTextArea(prologTextArea);
        this.inputTheory.setTokenMarker(new PrologTokenMarker());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.inputTheory.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                JavaEditArea.this.setCaretLine(JavaEditArea.this.inputTheory.getCaretLine() + 1);
            }
        });
        this.dirty = false;
        this.inputTheory.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (!JavaEditArea.this.dirty) {
                    JavaEditArea.this.setDirty(true);
                }
            }
        });
        this.undoManager = new UndoManager();
        this.inputTheory.getDocument().addUndoableEditListener(this.undoManager);
        this.add((Component)this.inputTheory, gridBagConstraints);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    private void setKeyBindings(PrologTextArea prologTextArea) {
        prologTextArea.inputHandler.addKeyBinding("C+Z", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaEditArea.this.undoAction();
            }
        });
        prologTextArea.inputHandler.addKeyBinding("CS+Z", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaEditArea.this.redoAction();
            }
        });
    }

    public void setCaretLine(int n) {
        int n2 = this.getCaretLine();
        this.caretLine = n;
        this.propertyChangeSupport.firePropertyChange("caretLine", n2, n);
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setTheory(String string) {
        this.inputTheory.setText(string);
    }

    public String getTheory() {
        return this.inputTheory.getText();
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void undoAction() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redoAction() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }
}

