/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.event.LibraryEvent;
import alice.tuprolog.event.LibraryListener;
import alice.tuprologx.ide.LibraryManager;
import alice.util.thinlet.Thinlet;
import java.awt.Container;
import java.awt.Window;

public class LibraryDialog
extends Thinlet
implements LibraryListener {
    private LibraryManager libraryManager;

    public LibraryDialog(LibraryManager libraryManager) {
        try {
            this.add(this.parse("xml/LibraryDialog.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.libraryManager = libraryManager;
        this.displayLibraryManagerStatus();
    }

    private void displayLibraryManagerStatus() {
        Object[] objectArray = this.libraryManager.getLibraries();
        for (int i = 0; i < objectArray.length; ++i) {
            this.createTextField(objectArray[i]);
            this.createComboBox(objectArray[i]);
        }
    }

    private void createTextField(Object object) {
        Object object2 = this.create("textfield");
        this.add(this.find("librariesDisplay"), object2, 0);
        String string = object.toString();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        this.setString(object2, "text", string2);
        this.setInteger(object2, "weightx", 90);
    }

    private void createComboBox(Object object) {
        Object object2 = this.create("combobox");
        this.add(this.find("librariesDisplay"), object2, 1);
        this.setBoolean(object2, "editable", false);
        Object object3 = this.create("choice");
        this.add(object2, object3, 0);
        this.setString(object3, "text", "Loaded");
        Object object4 = this.create("choice");
        this.add(object2, object4, 1);
        this.setString(object4, "text", "Unloaded");
        boolean bl = this.libraryManager.isLibraryLoaded(object.toString());
        this.setInteger(object2, "selected", bl ? 0 : 1);
        this.setInteger(object2, "weightx", 10);
    }

    private void setStatusMessage(String string) {
        this.setString(this.find("statusTextField"), "text", string);
    }

    public void addLibrary(String string) {
        try {
            this.libraryManager.addLibrary(string);
            this.removeAll(this.find("librariesDisplay"));
            this.displayLibraryManagerStatus();
            this.setStatusMessage("Ready.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setStatusMessage(string + ": Class Not Found");
        }
        catch (InvalidLibraryException invalidLibraryException) {
            this.setStatusMessage(string + ": Not a Library");
        }
    }

    public void setLibraryManagerStatus() {
        Object[] objectArray = this.getItems(this.find("librariesDisplay"));
        Object[] objectArray2 = this.libraryManager.getLibraries();
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = objectArray2[i / 2].toString();
            String string2 = this.getString(objectArray[objectArray.length - i - 2], "text");
            String string3 = this.getString(objectArray[objectArray.length - i - 1], "text");
            try {
                if (string3.equals("Loaded")) {
                    this.libraryManager.loadLibrary(string);
                }
                if (string3.equals("Unloaded")) {
                    this.libraryManager.unloadLibrary(string);
                }
                this.closeLibraryDialog();
                continue;
            }
            catch (InvalidLibraryException invalidLibraryException) {
                this.setStatusMessage(invalidLibraryException.getMessage());
            }
        }
    }

    public void closeLibraryDialog() {
        Container container = this.getParent();
        while (!(container instanceof Window)) {
            container = container.getParent();
        }
        ((Window)container).dispose();
    }

    public void libraryLoaded(LibraryEvent libraryEvent) {
        String string = libraryEvent.getLibraryName();
        if (!this.libraryManager.contains(string)) {
            this.addLibrary(string);
        } else {
            this.removeAll(this.find("librariesDisplay"));
            this.displayLibraryManagerStatus();
        }
    }

    public void libraryUnloaded(LibraryEvent libraryEvent) {
        String string = libraryEvent.getLibraryName();
        this.removeAll(this.find("librariesDisplay"));
        this.displayLibraryManagerStatus();
    }
}

