/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.BoardFrame;
import GUI.MainViewController;
import GUI.PredicatesFrame;
import GUI.StackTraceFrame;
import GUI.ViewComponents;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jovolog.Jovolog;
import jovolog.utils.ExceptionHandler;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MainView
extends FrameView {
    private final MainViewController controller = new MainViewController();
    private final PredicatesFrame predicatesFrame = new PredicatesFrame();
    private final BoardFrame boardFrame = new BoardFrame();
    private final StackTraceFrame stackTraceFrame = new StackTraceFrame();
    private JButton jButtonClearLog;
    private JButton jButtonMultistepWithLimit;
    private JButton jButtonRegenerateWorld;
    private JButton jButtonReload;
    private JButton jButtonResetSimulation;
    private JButton jButtonStartPause;
    private JButton jButtonStepOne;
    private JEditorPane jEditorPaneWorldParameters;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelCurrentPlayerPoints;
    private JLabel jLabelCurrentStep;
    private JLabel jLabelLoadedPlayer;
    private JLabel jLabelLoadedWorld;
    private JList jListAvailablePlayers;
    private JList jListAvailableWorlds;
    private JMenu jMenu2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSlider jSliderGameSpeed;
    private JSpinner jSpinnerStepLimit;
    private JTextArea jTextAreaGameLog;
    private JMenuBar menuBar;
    private JDialog aboutBox;

    public MainView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.initController();
    }

    public void setupFrames() throws HeadlessException {
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        ExceptionHandler.setStackTraceFrame(this.stackTraceFrame);
        this.stackTraceFrame.setLocation(0, 0);
        this.stackTraceFrame.setSize(new Dimension(rect.width, rect.height));
        this.getFrame().setLocation(0, 0);
        this.getFrame().setSize(new Dimension(rect.width / 2, rect.height));
        this.predicatesFrame.setLocation(rect.width / 2, 0);
        this.predicatesFrame.setSize(new Dimension(rect.width / 2, rect.height / 2));
        this.predicatesFrame.setVisible(true);
        this.boardFrame.setLocation(rect.width / 2, rect.height / 2);
        int boardDim = Math.min(rect.width / 2, rect.height / 2);
        this.boardFrame.setSize(new Dimension(boardDim, boardDim));
        this.boardFrame.setVisible(true);
    }

    private void initController() {
        ViewComponents c = new ViewComponents();
        c.listAvailableWorlds = this.jListAvailableWorlds;
        c.listAvailablePlayers = this.jListAvailablePlayers;
        c.labelLoadedWorld = this.jLabelLoadedWorld;
        c.labelLoadedPlayer = this.jLabelLoadedPlayer;
        c.labelCurrentStep = this.jLabelCurrentStep;
        c.labelCurrentPlayerPoints = this.jLabelCurrentPlayerPoints;
        c.buttonStartPause = this.jButtonStartPause;
        c.buttonStep = this.jButtonStepOne;
        c.buttonResetSimulation = this.jButtonResetSimulation;
        c.buttonResetWorld = this.jButtonRegenerateWorld;
        c.buttonMultistepWithLimit = this.jButtonMultistepWithLimit;
        c.buttonReload = this.jButtonReload;
        c.gameLog = this.jTextAreaGameLog;
        c.worldParameters = this.jEditorPaneWorldParameters;
        c.spinnerStepLimit = this.jSpinnerStepLimit;
        c.sliderGameSpeed = this.jSliderGameSpeed;
        c.playerActionPredicate = this.predicatesFrame.jLabelPlayerActionPredicate;
        c.gameStatusPredicate = this.predicatesFrame.jLabelGameStatusPredicate;
        c.worldPredicates = this.predicatesFrame.jTextAreaWorldPredicates;
        c.playerPerceptsPredicates = this.predicatesFrame.jTextAreaPlayerPerceptsPredicates;
        c.playerKnowledgePredicates = this.predicatesFrame.jTextAreaPlayerKnowledgePredicates;
        c.boardPanel = this.boardFrame.boardPanel;
        this.controller.init(this.getFrame(), Jovolog.getApplication().model, c);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorPaneWorldParameters = new JEditorPane();
        this.jPanel5 = new JPanel();
        this.jButtonStartPause = new JButton();
        this.jButtonStepOne = new JButton();
        this.jButtonMultistepWithLimit = new JButton();
        this.jButtonResetSimulation = new JButton();
        this.jSliderGameSpeed = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabelCurrentStep = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSpinnerStepLimit = new JSpinner();
        this.jButtonReload = new JButton();
        this.jButtonRegenerateWorld = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabelCurrentPlayerPoints = new JLabel();
        this.jPanel11 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListAvailablePlayers = new JList();
        this.jPanel6 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextAreaGameLog = new JTextArea();
        this.jButtonClearLog = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jListAvailableWorlds = new JList();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabelLoadedWorld = new JLabel();
        this.jLabelLoadedPlayer = new JLabel();
        this.menuBar.setName("menuBar");
        fileMenu.setMnemonic(70);
        ResourceMap resourceMap = Application.getInstance(Jovolog.class).getContext().getResourceMap(MainView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(Jovolog.class).getContext().getActionMap(MainView.class, this);
        this.jMenuItem6.setAction(actionMap.get("loadWorld"));
        this.jMenuItem6.setMnemonic(79);
        this.jMenuItem6.setText(resourceMap.getString("jMenuItem6.text", new Object[0]));
        this.jMenuItem6.setName("jMenuItem6");
        fileMenu.add(this.jMenuItem6);
        this.jMenuItem1.setAction(actionMap.get("loadPlayer"));
        this.jMenuItem1.setMnemonic(76);
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        fileMenu.add(this.jMenuItem1);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.jMenu2.setMnemonic('w');
        this.jMenu2.setText(resourceMap.getString("jMenu2.text", new Object[0]));
        this.jMenu2.setName("jMenu2");
        this.jMenuItem7.setAction(actionMap.get("showPredicatesWindow"));
        this.jMenuItem7.setMnemonic(80);
        this.jMenuItem7.setText(resourceMap.getString("jMenuItem7.text", new Object[0]));
        this.jMenuItem7.setName("jMenuItem7");
        this.jMenu2.add(this.jMenuItem7);
        this.jMenuItem8.setAction(actionMap.get("showBoardWindow"));
        this.jMenuItem8.setMnemonic(66);
        this.jMenuItem8.setText(resourceMap.getString("jMenuItem8.text", new Object[0]));
        this.jMenuItem8.setName("jMenuItem8");
        this.jMenu2.add(this.jMenuItem8);
        this.menuBar.add(this.jMenu2);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel10.setMinimumSize(new Dimension(300, 500));
        this.jPanel10.setName("jPanel10");
        this.jPanel10.setPreferredSize(new Dimension(300, 500));
        this.jPanel10.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel4.border.title", new Object[0])));
        this.jPanel4.setMinimumSize(new Dimension(350, 200));
        this.jPanel4.setName("jPanel4");
        this.jPanel4.setPreferredSize(new Dimension(350, 200));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setMaximumSize(new Dimension(0, 0));
        this.jScrollPane3.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane3.setName("jScrollPane3");
        this.jScrollPane3.setPreferredSize(new Dimension(0, 0));
        this.jEditorPaneWorldParameters.setMaximumSize(new Dimension(0, 0));
        this.jEditorPaneWorldParameters.setMinimumSize(new Dimension(0, 0));
        this.jEditorPaneWorldParameters.setName("jEditorPaneWorldParameters");
        this.jEditorPaneWorldParameters.setPreferredSize(new Dimension(0, 0));
        this.jScrollPane3.setViewportView(this.jEditorPaneWorldParameters);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel10.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel5.border.title", new Object[0])));
        this.jPanel5.setMinimumSize(new Dimension(250, 300));
        this.jPanel5.setName("jPanel5");
        this.jPanel5.setPreferredSize(new Dimension(250, 300));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButtonStartPause.setAction(actionMap.get("buttonActionStartPause"));
        this.jButtonStartPause.setMnemonic(65);
        this.jButtonStartPause.setText(resourceMap.getString("jButtonStartPause.text", new Object[0]));
        this.jButtonStartPause.setMaximumSize(new Dimension(130, 40));
        this.jButtonStartPause.setMinimumSize(new Dimension(130, 40));
        this.jButtonStartPause.setName("jButtonStartPause");
        this.jButtonStartPause.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonStartPause, gridBagConstraints);
        this.jButtonStepOne.setAction(actionMap.get("buttonActionStep"));
        this.jButtonStepOne.setMnemonic(83);
        this.jButtonStepOne.setText(resourceMap.getString("jButtonStepOne.text", new Object[0]));
        this.jButtonStepOne.setMaximumSize(new Dimension(130, 40));
        this.jButtonStepOne.setMinimumSize(new Dimension(130, 40));
        this.jButtonStepOne.setName("jButtonStepOne");
        this.jButtonStepOne.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonStepOne, gridBagConstraints);
        this.jButtonMultistepWithLimit.setAction(actionMap.get("buttonActionMultistepWithLimit"));
        this.jButtonMultistepWithLimit.setMnemonic(77);
        this.jButtonMultistepWithLimit.setText(resourceMap.getString("jButtonMultistepWithLimit.text", new Object[0]));
        this.jButtonMultistepWithLimit.setMaximumSize(new Dimension(130, 40));
        this.jButtonMultistepWithLimit.setMinimumSize(new Dimension(130, 40));
        this.jButtonMultistepWithLimit.setName("jButtonMultistepWithLimit");
        this.jButtonMultistepWithLimit.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonMultistepWithLimit, gridBagConstraints);
        this.jButtonResetSimulation.setAction(actionMap.get("buttonActionReset"));
        this.jButtonResetSimulation.setMnemonic(82);
        this.jButtonResetSimulation.setText(resourceMap.getString("jButtonResetSimulation.text", new Object[0]));
        this.jButtonResetSimulation.setMaximumSize(new Dimension(130, 40));
        this.jButtonResetSimulation.setMinimumSize(new Dimension(130, 40));
        this.jButtonResetSimulation.setName("jButtonResetSimulation");
        this.jButtonResetSimulation.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonResetSimulation, gridBagConstraints);
        this.jSliderGameSpeed.setMajorTickSpacing(1);
        this.jSliderGameSpeed.setMaximum(10);
        this.jSliderGameSpeed.setMinimum(1);
        this.jSliderGameSpeed.setPaintLabels(true);
        this.jSliderGameSpeed.setPaintTicks(true);
        this.jSliderGameSpeed.setSnapToTicks(true);
        this.jSliderGameSpeed.setValue(5);
        this.jSliderGameSpeed.setMinimumSize(new Dimension(0, 70));
        this.jSliderGameSpeed.setName("jSliderGameSpeed");
        this.jSliderGameSpeed.setPreferredSize(new Dimension(0, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jSliderGameSpeed, gridBagConstraints);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setName("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel5.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabelCurrentStep.setHorizontalAlignment(11);
        this.jLabelCurrentStep.setText(resourceMap.getString("jLabelCurrentStep.text", new Object[0]));
        this.jLabelCurrentStep.setName("jLabelCurrentStep");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jLabelCurrentStep, gridBagConstraints);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jLabel7, gridBagConstraints);
        this.jSpinnerStepLimit.setModel(new SpinnerNumberModel(10, 1, 1024, 1));
        this.jSpinnerStepLimit.setMinimumSize(new Dimension(80, 20));
        this.jSpinnerStepLimit.setName("jSpinnerStepLimit");
        this.jSpinnerStepLimit.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jSpinnerStepLimit, gridBagConstraints);
        this.jButtonReload.setAction(actionMap.get("buttonActionReload"));
        this.jButtonReload.setMnemonic(69);
        this.jButtonReload.setText(resourceMap.getString("jButtonReload.text", new Object[0]));
        this.jButtonReload.setMaximumSize(new Dimension(130, 40));
        this.jButtonReload.setMinimumSize(new Dimension(130, 40));
        this.jButtonReload.setName("jButtonReload");
        this.jButtonReload.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonReload, gridBagConstraints);
        this.jButtonRegenerateWorld.setAction(actionMap.get("buttonActionRegenerateWorld"));
        this.jButtonRegenerateWorld.setMnemonic(71);
        this.jButtonRegenerateWorld.setText(resourceMap.getString("jButtonRegenerateWorld.text", new Object[0]));
        this.jButtonRegenerateWorld.setMaximumSize(new Dimension(130, 40));
        this.jButtonRegenerateWorld.setMinimumSize(new Dimension(130, 40));
        this.jButtonRegenerateWorld.setName("jButtonRegenerateWorld");
        this.jButtonRegenerateWorld.setPreferredSize(new Dimension(130, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel5.add((Component)this.jButtonRegenerateWorld, gridBagConstraints);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabelCurrentPlayerPoints.setText(resourceMap.getString("jLabelCurrentPlayerPoints.text", new Object[0]));
        this.jLabelCurrentPlayerPoints.setName("jLabelCurrentPlayerPoints");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jLabelCurrentPlayerPoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel10.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setMinimumSize(new Dimension(300, 500));
        this.jPanel11.setName("jPanel11");
        this.jPanel11.setPreferredSize(new Dimension(300, 500));
        this.jPanel11.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setMinimumSize(new Dimension(120, 150));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setPreferredSize(new Dimension(120, 150));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(new Dimension(0, 0));
        this.jScrollPane1.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.setPreferredSize(new Dimension(0, 0));
        this.jListAvailablePlayers.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListAvailablePlayers.setName("jListAvailablePlayers");
        this.jListAvailablePlayers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainView.this.jListAvailablePlayersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListAvailablePlayers);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel11.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel6.border.title", new Object[0])));
        this.jPanel6.setMinimumSize(new Dimension(240, 250));
        this.jPanel6.setName("jPanel6");
        this.jPanel6.setPreferredSize(new Dimension(240, 250));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jScrollPane4.setHorizontalScrollBarPolicy(31);
        this.jScrollPane4.setMaximumSize(new Dimension(0, 0));
        this.jScrollPane4.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane4.setName("jScrollPane4");
        this.jScrollPane4.setPreferredSize(new Dimension(0, 0));
        this.jTextAreaGameLog.setColumns(20);
        this.jTextAreaGameLog.setEditable(false);
        this.jTextAreaGameLog.setFont(new Font("Tahoma", 0, 11));
        this.jTextAreaGameLog.setLineWrap(true);
        this.jTextAreaGameLog.setRows(5);
        this.jTextAreaGameLog.setWrapStyleWord(true);
        this.jTextAreaGameLog.setMaximumSize(new Dimension(0, 0));
        this.jTextAreaGameLog.setMinimumSize(new Dimension(0, 0));
        this.jTextAreaGameLog.setName("jTextAreaGameLog");
        this.jScrollPane4.setViewportView(this.jTextAreaGameLog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jButtonClearLog.setAction(actionMap.get("buttonActionClearLog"));
        this.jButtonClearLog.setMnemonic(67);
        this.jButtonClearLog.setText(resourceMap.getString("jButtonClearLog.text", new Object[0]));
        this.jButtonClearLog.setMaximumSize(new Dimension(0, 0));
        this.jButtonClearLog.setMinimumSize(new Dimension(0, 0));
        this.jButtonClearLog.setName("jButtonClearLog");
        this.jButtonClearLog.setPreferredSize(new Dimension(90, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel6.add((Component)this.jButtonClearLog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel11.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel3.border.title", new Object[0])));
        this.jPanel3.setMinimumSize(new Dimension(120, 150));
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setPreferredSize(new Dimension(120, 150));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane2.setMaximumSize(new Dimension(0, 0));
        this.jScrollPane2.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane2.setName("jScrollPane2");
        this.jScrollPane2.setPreferredSize(new Dimension(0, 0));
        this.jListAvailableWorlds.setModel(new AbstractListModel(){
            String[] strings = new String[]{"item 1", "item 2", "item 3", "item 4", "item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListAvailableWorlds.setSelectionMode(0);
        this.jListAvailableWorlds.setName("jListAvailableWorlds");
        this.jListAvailableWorlds.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainView.this.jListAvailableWorldsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListAvailableWorlds);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel11.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setMaximumSize(new Dimension(100, 15));
        this.jLabel3.setMinimumSize(new Dimension(100, 15));
        this.jLabel3.setName("jLabel3");
        this.jLabel3.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel11.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setMaximumSize(new Dimension(100, 15));
        this.jLabel4.setMinimumSize(new Dimension(100, 15));
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel11.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabelLoadedWorld.setText(resourceMap.getString("jLabelLoadedWorld.text", new Object[0]));
        this.jLabelLoadedWorld.setMaximumSize(new Dimension(100, 15));
        this.jLabelLoadedWorld.setMinimumSize(new Dimension(100, 15));
        this.jLabelLoadedWorld.setName("jLabelLoadedWorld");
        this.jLabelLoadedWorld.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel11.add((Component)this.jLabelLoadedWorld, gridBagConstraints);
        this.jLabelLoadedPlayer.setText(resourceMap.getString("jLabelLoadedPlayer.text", new Object[0]));
        this.jLabelLoadedPlayer.setMaximumSize(new Dimension(100, 15));
        this.jLabelLoadedPlayer.setMinimumSize(new Dimension(100, 15));
        this.jLabelLoadedPlayer.setName("jLabelLoadedPlayer");
        this.jLabelLoadedPlayer.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel11.add((Component)this.jLabelLoadedPlayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel11, gridBagConstraints);
        this.setComponent(this.jPanel1);
        this.setMenuBar(this.menuBar);
    }

    private void jListAvailableWorldsValueChanged(ListSelectionEvent evt) {
        if (!this.jListAvailableWorlds.getValueIsAdjusting()) {
            this.controller.updateSelectedWorld();
        }
    }

    private void jListAvailablePlayersValueChanged(ListSelectionEvent evt) {
        if (!this.jListAvailablePlayers.getValueIsAdjusting()) {
            this.controller.updateSelectedPlayer();
        }
    }

    @Action
    public void showPredicatesWindow() {
        this.predicatesFrame.setVisible(true);
    }

    @Action
    public void showBoardWindow() {
        this.boardFrame.setVisible(true);
    }

    @Action
    public void buttonActionMultistepWithLimit() {
        this.controller.multistepWithLimit();
    }

    @Action
    public void buttonActionStep() {
        this.controller.step();
    }

    @Action
    public void buttonActionReset() {
        this.controller.reset();
    }

    @Action
    public void buttonActionStartPause() {
        this.controller.startPause();
    }

    @Action
    public void buttonActionReload() {
        this.controller.reload();
    }

    @Action
    public void buttonActionClearLog() {
        this.controller.clearLog();
    }

    @Action
    public void buttonActionRegenerateWorld() {
        this.controller.generateWorld();
    }

    @Action
    public void loadWorld() {
        this.controller.loadWorld();
    }

    @Action
    public void loadPlayer() {
        this.controller.loadPlayer();
    }
}

