/*
 * Decompiled with CFR 0.152.
 */
package jovolog.model;

import GUI.Board;
import GUI.MainViewController;
import javax.swing.Timer;
import jovolog.model.JovologEngine;
import jovolog.model.JovologEngineException;
import jovolog.model.PrologSource;

public class JovologEngineController {
    private MainViewController outerController;
    private JovologEngine engine;
    private Timer engineTimer;

    public JovologEngineController(MainViewController outerController) {
        this.outerController = outerController;
        this.engineTimer = new Timer(0, this.outerController);
    }

    public void setEngine(JovologEngine engine) {
        this.engine = engine;
    }

    public void multistepWithLimit(int stepLimit) throws JovologEngineException {
        if (stepLimit <= 0) {
            return;
        }
        do {
            this.engine.step();
        } while (!this.engine.gameEnded() && --stepLimit > 0);
    }

    public void loadPlayer(PrologSource source) throws JovologEngineException {
        this.engine.loadPlayer(source);
    }

    public void loadWorld(PrologSource source) throws JovologEngineException {
        this.engine.loadWorld(source);
    }

    public void purgeWorld() {
        this.engine.purgeWorld();
    }

    public void purge() {
        this.engine.purge();
    }

    public void step(int stepCount) throws JovologEngineException {
        do {
            this.engine.step();
        } while (--stepCount > 0 && !this.engine.gameEnded());
    }

    public boolean gameEnded() {
        return this.engine.gameEnded();
    }

    public int getPoints() {
        return this.engine.getPoints();
    }

    public void reset() throws JovologEngineException {
        this.engine.reset();
    }

    public void generateWorld(String worldParameters) throws JovologEngineException {
        this.engine.setWorldParameters(worldParameters);
        this.engine.generateWorld();
    }

    public int getCurrentStep() {
        return this.engine.getCurrentStep();
    }

    public void pause() {
        this.engineTimer.stop();
    }

    public void start(int delay) {
        this.engineTimer.setDelay(1000 / delay);
        this.engineTimer.start();
    }

    public boolean engineReady() {
        return this.engine.ready();
    }

    public String getPlayerActionPredicate() {
        return this.engine.getPlayerActionPredicate();
    }

    public String getGameStatusPredicate() {
        return this.engine.getGameStatusPredicate();
    }

    public String getWorldPredicates() {
        return this.engine.getWorldPredicates();
    }

    public String getPlayerPerceptsPredicates() {
        return this.engine.getPlayerPerceptsPredicates();
    }

    public String getPlayerKnowledgePredicates() {
        return this.engine.getPlayerKnowledgePredicates();
    }

    public String getDefaultWorldParameters() {
        return this.engine.getDefaultWorldParameters();
    }

    public Board getBoardDisplay() {
        return this.engine.getDisplay();
    }

    public String getGameStatusMessage() {
        String msg = this.engine.getGameStatusMessage();
        return msg.substring(1, msg.length() - 1);
    }
}

