/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.tcp;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PrologImpl
implements Serializable {
    Prolog core;

    public PrologImpl(Prolog prolog) {
        this.core = prolog;
    }

    public void clearTheory(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) {
        this.core.clearTheory();
    }

    public void getTheory(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        Theory theory = this.core.getTheory();
        objectOutputStream.writeObject(new Boolean(false));
        objectOutputStream.writeObject(theory);
    }

    public void setTheory(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            Theory theory = (Theory)objectInputStream.readObject();
            this.core.setTheory(theory);
            objectOutputStream.writeObject(new Boolean(true));
        }
        catch (InvalidTheoryException invalidTheoryException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }

    public void addTheory(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            Theory theory = (Theory)objectInputStream.readObject();
            this.core.addTheory(theory);
            objectOutputStream.writeObject(new Boolean(true));
        }
        catch (InvalidTheoryException invalidTheoryException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }

    public void solveString(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            String string = (String)objectInputStream.readObject();
            SolveInfo solveInfo = this.core.solve(string);
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.writeObject(solveInfo);
        }
        catch (MalformedGoalException malformedGoalException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }

    public void hasOpenAlternatives(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        objectOutputStream.writeObject(new Boolean(this.core.hasOpenAlternatives()));
    }

    public void solveTerm(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        Term term = (Term)objectInputStream.readObject();
        SolveInfo solveInfo = this.core.solve(term);
        objectOutputStream.writeObject(new Boolean(true));
        objectOutputStream.writeObject(solveInfo);
    }

    public void solveNext(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            SolveInfo solveInfo = this.core.solveNext();
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.writeObject(solveInfo);
        }
        catch (NoMoreSolutionException noMoreSolutionException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }

    public void solveHalt(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) {
        this.core.solveHalt();
    }

    public void solveEnd(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) {
        this.core.solveEnd();
    }

    public void loadLibrary(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            String string = (String)objectInputStream.readObject();
            this.core.loadLibrary(string);
            objectOutputStream.writeObject(new Boolean(true));
        }
        catch (InvalidLibraryException invalidLibraryException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }

    public void unloadLibrary(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
        try {
            String string = (String)objectInputStream.readObject();
            this.core.unloadLibrary(string);
            objectOutputStream.writeObject(new Boolean(true));
        }
        catch (InvalidLibraryException invalidLibraryException) {
            objectOutputStream.writeObject(new Boolean(false));
        }
    }
}

