/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Theory;
import alice.tuprologx.ide.IOFileOperations;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JavaIOManager
extends IOFileOperations {
    private Component parent;

    public JavaIOManager(Component component) {
        this.parent = component;
    }

    public Theory loadTheory() throws Exception {
        JFileChooser jFileChooser = new JFileChooser(this.currentLoadDirectory);
        jFileChooser.setFileFilter(new PrologFileFilter());
        int n = jFileChooser.showOpenDialog(this.parent);
        if (n == 0) {
            this.currentLoadDirectory = jFileChooser.getCurrentDirectory().toString();
            this.currentTheoryFileName = jFileChooser.getCurrentDirectory() + File.separator + jFileChooser.getSelectedFile().getName();
            return new Theory(new FileInputStream(this.currentTheoryFileName));
        }
        return null;
    }

    public String saveTheoryAs(String string) throws Exception {
        JFileChooser jFileChooser = new JFileChooser(this.currentSaveDirectory);
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new PrologFileFilter());
        int n = jFileChooser.showSaveDialog(this.parent);
        if (n == 0) {
            this.currentSaveDirectory = jFileChooser.getCurrentDirectory().toString();
            this.currentTheoryFileName = jFileChooser.getCurrentDirectory() + File.separator + jFileChooser.getSelectedFile().getName();
            return this.save(string);
        }
        return "";
    }

    private class PrologFileFilter
    extends FileFilter {
        private PrologFileFilter() {
        }

        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if (string != null && (string.equals("pl") || string.equals("pro"))) {
                    return true;
                }
            }
            return false;
        }

        private String getExtension(File file) {
            String string;
            int n;
            if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return null;
        }

        public String getDescription() {
            return "Prolog files (*.pro, *.pl)";
        }
    }
}

