/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Board;
import GUI.BoardFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jovolog.utils.ExceptionHandler;
import jovolog.utils.IOManager;

public class BoardPanel
extends JPanel {
    private IOManager ioManager = new IOManager();
    private Board board;
    private JFrame parent;

    public BoardPanel(BoardFrame parent) {
        this.initComponents();
        this.parent = parent;
    }

    public BoardPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setName("Form");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.board == null) {
            return;
        }
        int cellWidth = this.getWidth() / this.board.getMaxX();
        int cellHeight = this.getHeight() / this.board.getMaxY();
        for (Board.BoardCell boardCell : this.board) {
            try {
                BufferedImage img = this.ioManager.getImage(boardCell.path);
                g.drawImage(img, cellWidth * (boardCell.x - 1), cellHeight * (this.board.getMaxY() - boardCell.y), cellWidth, cellHeight, this);
            }
            catch (IOException ex) {
                g2.setPaint(new Color(0));
                g2.fillRect(cellWidth * (boardCell.x - 1), cellHeight * (this.board.getMaxY() - boardCell.y), cellWidth, cellHeight);
            }
        }
    }

    void setBoard(Board board) {
        this.board = board;
        this.validateBoard();
        this.repaint();
    }

    void validateBoard() {
        for (Board.BoardCell boardCell : this.board) {
            try {
                this.ioManager.getImage(boardCell.path);
            }
            catch (IOException cause) {
                IOException ex = new IOException(String.format("\n\nCouldn't read image with path:\n%s\n\nCause:\n%s", "images" + IOManager.SEP + boardCell.path, cause), cause);
                ExceptionHandler.handle(ex, this.parent);
            }
        }
    }

    void clearBoard() {
        this.board = null;
        this.repaint();
    }
}

