/*
 * Decompiled with CFR 0.152.
 */
package jovolog.model;

import GUI.Board;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.StringTokenizer;
import jovolog.model.JovologEngineException;
import jovolog.model.PrologSource;
import jovolog.utils.ExceptionHandler;

public class JovologEngine {
    private static final int ENGINE_NOT_SET = -1;
    private static final String MSG_INVALID_WORLD = "World prolog source is invalid.\n\n%s";
    private static final String MSG_INVALID_PLAYER = "Player prolog source is invalid.\n\n%s";
    private static final String MSG_WORLD_NO_SOLUTION = "Invoking \"%s\" on world yielded no solution.";
    private static final String MSG_PLAYER_NO_SOLUTION = "Invoking \"%s\" on player yielded no solution.";
    private static final String MSG_INVALID_LIST = "Expected prolog list. Actual term: %s";
    private static final String MSG_INVALID_STRUCT = "Expected prolog struct. Actual term: %s";
    private static final String MSG_INVALID_TERM = "Invalid term presentation.TuProlog was unable to create term from following string:\n%s";
    private static final String DISPLAY_UNDEFINED = "N/A";
    private static final String TERMNAME_PLAYER_ACTION = "player_action";
    private static final String TERMNAME_SIMULATION_CONTINUE = "continue";
    private static final String VARNAME_DEFAULT_WORLD_PARAMS = "Params";
    private static final Term TERM_DEFAULT_WORLD_PARAMETERS = Term.createTerm((String)"default_world_params(Params)");
    private static final String VARNAME_GENERATED_WORLD = "GeneratedWorld";
    private static final String VARNAME_INIT_PLAYER_KNOWLEDGE = "PlayerKnowledge";
    private static final String VARNAME_INIT_PLAYER_PERCEPTS = "PlayerPercepts";
    private static final Term TERM_GENERATE_WORLD = Term.createTerm((String)"generate_world(GeneratedWorld,PlayerKnowledge,PlayerPercepts)");
    private static final String VARNAME_POINTS = "Points";
    private static final Term TERM_ITERATE_POINTS = Term.createTerm((String)"points(Points)");
    private static final String VARNAME_DISPLAY_SIZE = "DisplaySize";
    private static final String VARNAME_DISPLAY = "Display";
    private static final Term TERM_ITERATE_DISPLAY = Term.createTerm((String)"generate_display(DisplaySize,Display)");
    private static final String VARNAME_NEXT_WORLD = "NextWorld";
    private static final String VARNAME_GAME_STATUS = "GameStatus";
    private static final String VARNAME_PLAYER_KNOWLEDGE = "PlayerPercepts";
    private static final Term TERM_ITERATE_WORLD = Term.createTerm((String)"react(GameStatus,NextWorld,PlayerPercepts)");
    private static final String VARNAME_PLAYER_GENERATED_KNOWLEDGE = "Knowledge";
    private static final String VARNAME_PLAYER_ACTION = "Action";
    private static final Term TERM_ITERATE_PLAYER = Term.createTerm((String)"act(Action,Knowledge)");
    private Prolog playerEngine = new Prolog();
    private Prolog worldEngine = new Prolog();
    private Theory player;
    private Theory world;
    private SimulationStatus simulationStatus;
    private InitWorldSnapshot initWorldSnapshot;
    private int currStep = -1;
    private PrologList worldParameters;
    private PrologList defaultWorldParameters;

    JovologEngine() {
        try {
            this.playerEngine.loadLibrary("alice.tuprolog.lib.DCGLibrary");
            this.worldEngine.loadLibrary("alice.tuprolog.lib.DCGLibrary");
        }
        catch (InvalidLibraryException ex) {
            ExceptionHandler.handleNoStack((Exception)((Object)ex), null, "Oh snap!\nFailed loading alice.tuprolog.lib.DCGLibrary.\n\nReason:\n\n" + (Object)((Object)ex) + "\n\n");
        }
    }

    void loadWorld(PrologSource world) throws JovologEngineException {
        try {
            this.worldEngine.setTheory(world.getTheory());
            this.world = world.getTheory();
            this.loadDefaultWorldParameters();
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
    }

    void loadPlayer(PrologSource player) throws JovologEngineException {
        try {
            this.playerEngine.setTheory(player.getTheory());
            this.player = player.getTheory();
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_PLAYER, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
    }

    void purgeWorld() {
        this.world = null;
        this.worldParameters = null;
        this.initWorldSnapshot = null;
        this.simulationStatus = null;
        this.currStep = -1;
    }

    void purge() {
        this.world = null;
        this.player = null;
        this.worldParameters = null;
        this.initWorldSnapshot = null;
        this.simulationStatus = null;
        this.currStep = -1;
    }

    boolean ready() {
        return this.world != null && this.player != null;
    }

    boolean gameEnded() {
        return this.simulationStatus.ended();
    }

    void reset() throws JovologEngineException {
        if (!this.ready()) {
            throw new JovologEngineException("Engine not ready. World or Player is null.");
        }
        this.reloadTheories();
        this.resetWorld();
        this.iteratePoints();
        this.iterateDisplay();
        this.currStep = 0;
    }

    void step() throws JovologEngineException {
        if (this.currStep == -1) {
            this.reset();
        }
        ++this.currStep;
        this.iteratePlayer();
        this.iterateWorld();
        this.iteratePoints();
        this.iterateDisplay();
        if (this.simulationStatus.ended()) {
            return;
        }
    }

    void generateWorld() throws JovologEngineException {
        try {
            this.worldEngine.setTheory(this.world);
            this.worldParameters.appendTo(this.worldEngine);
            SolveInfo si = this.worldEngine.solve(TERM_GENERATE_WORLD);
            this.initWorldSnapshot = new InitWorldSnapshot(si.getVarValue(VARNAME_GENERATED_WORLD), si.getVarValue(VARNAME_INIT_PLAYER_KNOWLEDGE), si.getVarValue("PlayerPercepts"));
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_WORLD_NO_SOLUTION, TERM_GENERATE_WORLD.toString()), (Exception)((Object)ex));
        }
    }

    private void loadDefaultWorldParameters() throws JovologEngineException {
        SolveInfo si = this.worldEngine.solve(TERM_DEFAULT_WORLD_PARAMETERS);
        try {
            this.worldParameters = this.defaultWorldParameters = new PrologList(si.getVarValue(VARNAME_DEFAULT_WORLD_PARAMS));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_WORLD_NO_SOLUTION, TERM_DEFAULT_WORLD_PARAMETERS.toString()), (Exception)((Object)ex));
        }
    }

    private void reloadTheories() throws JovologEngineException {
        Theory currWorld = this.worldEngine.getTheory();
        try {
            this.worldEngine.setTheory(this.world);
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        try {
            this.playerEngine.setTheory(this.player);
        }
        catch (InvalidTheoryException ex) {
            try {
                this.worldEngine.setTheory(currWorld);
            }
            catch (InvalidTheoryException ex1) {
                throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex1.getLocalizedMessage()), (Exception)((Object)ex));
            }
            throw new JovologEngineException(String.format(MSG_INVALID_PLAYER, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
    }

    private void resetWorld() throws JovologEngineException {
        if (this.initWorldSnapshot == null) {
            this.generateWorld();
        }
        this.simulationStatus = new SimulationStatus(this.initWorldSnapshot);
    }

    private void iterateWorld() throws JovologEngineException {
        try {
            this.worldEngine.setTheory(this.world);
            this.simulationStatus.world.appendTo(this.worldEngine);
            this.simulationStatus.playerAction.wrap(TERMNAME_PLAYER_ACTION).appendTo(this.worldEngine);
            SolveInfo si = this.worldEngine.solve(TERM_ITERATE_WORLD);
            this.simulationStatus.writeReact(si.getVarValue(VARNAME_GAME_STATUS), si.getVarValue(VARNAME_NEXT_WORLD), si.getVarValue("PlayerPercepts"));
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_WORLD_NO_SOLUTION, TERM_ITERATE_WORLD.toString()), (Exception)((Object)ex));
        }
    }

    private void iteratePoints() throws JovologEngineException {
        try {
            this.worldEngine.setTheory(this.world);
            this.simulationStatus.world.appendTo(this.worldEngine);
            SolveInfo si = this.worldEngine.solve(TERM_ITERATE_POINTS);
            this.simulationStatus.writePoints(si.getVarValue(VARNAME_POINTS));
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_WORLD_NO_SOLUTION, TERM_ITERATE_POINTS.toString()), (Exception)((Object)ex));
        }
    }

    private void iterateDisplay() throws JovologEngineException {
        try {
            this.worldEngine.setTheory(this.world);
            this.simulationStatus.world.appendTo(this.worldEngine);
            SolveInfo si = this.worldEngine.solve(TERM_ITERATE_DISPLAY);
            this.simulationStatus.writeDisplay(si.getVarValue(VARNAME_DISPLAY_SIZE), si.getVarValue(VARNAME_DISPLAY));
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_WORLD, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_WORLD_NO_SOLUTION, TERM_ITERATE_DISPLAY.toString()), (Exception)((Object)ex));
        }
    }

    private void iteratePlayer() throws JovologEngineException {
        try {
            this.playerEngine.setTheory(this.player);
            this.simulationStatus.playerKnowledge.appendTo(this.playerEngine);
            this.simulationStatus.playerPercepts.appendTo(this.playerEngine);
            SolveInfo si = this.playerEngine.solve(TERM_ITERATE_PLAYER);
            this.simulationStatus.writeAct(si.getVarValue(VARNAME_PLAYER_ACTION), si.getVarValue(VARNAME_PLAYER_GENERATED_KNOWLEDGE));
        }
        catch (InvalidTheoryException ex) {
            throw new JovologEngineException(String.format(MSG_INVALID_PLAYER, ex.getLocalizedMessage()), (Exception)((Object)ex));
        }
        catch (NoSolutionException ex) {
            throw new JovologEngineException(String.format(MSG_PLAYER_NO_SOLUTION, TERM_ITERATE_PLAYER.toString()), (Exception)((Object)ex));
        }
    }

    private Term appendTerm(Term appendedTerm) {
        return Term.createTerm((String)("asserta(" + appendedTerm + ")"));
    }

    int getCurrentStep() {
        return this.currStep;
    }

    int getPoints() {
        return this.simulationStatus.getPoints();
    }

    String getPlayerActionPredicate() {
        if (this.simulationStatus.playerAction == null) {
            return DISPLAY_UNDEFINED;
        }
        return this.simulationStatus.playerAction.toString();
    }

    String getGameStatusPredicate() {
        if (this.simulationStatus.gameStatus == null) {
            return DISPLAY_UNDEFINED;
        }
        return this.simulationStatus.gameStatus.toString();
    }

    void setWorldParameters(String worldParameters) throws JovologEngineException {
        this.worldParameters = new PrologList(worldParameters);
    }

    String getWorldPredicates() {
        return this.simulationStatus.world.toString();
    }

    String getPlayerPerceptsPredicates() {
        return this.simulationStatus.playerPercepts.toString();
    }

    String getPlayerKnowledgePredicates() {
        return this.simulationStatus.playerKnowledge.toString();
    }

    String getDefaultWorldParameters() {
        return this.defaultWorldParameters.toString(1);
    }

    String getGameStatusMessage() {
        return this.simulationStatus.gameStatus.getArg(0).toString();
    }

    Board getDisplay() {
        Board board = new Board();
        for (Term term : this.simulationStatus.display) {
            Struct s1 = (Struct)term.getTerm();
            Struct s2 = (Struct)s1.getArg(1).getTerm();
            Struct s3 = (Struct)s2.getArg(1).getTerm();
            int x = Integer.parseInt(s1.getArg(0).toString());
            int y = Integer.parseInt(s2.getArg(0).toString());
            String img_path = s3.getName();
            board.set(x, y, img_path);
            board.setSize(this.simulationStatus.displaySize);
        }
        return board;
    }

    private class DecoratedStruct {
        private Struct struct;

        public DecoratedStruct(Term term) {
            this.struct = (Struct)term;
        }

        private DecoratedStruct wrap(String termname) {
            return new DecoratedStruct(Term.createTerm((String)(termname + "(" + this.struct + ")")));
        }

        private void appendTo(Prolog engine) {
            engine.solve(JovologEngine.this.appendTerm((Term)this.struct));
        }

        public String toString() {
            return this.struct.toString();
        }
    }

    private class InitWorldSnapshot {
        PrologList world;
        PrologList playerKnowledge;
        PrologList playerPercepts;

        private InitWorldSnapshot(Term initWorld, Term initPlayerKnowledge, Term initPlayerPercepts) throws JovologEngineException {
            this.world = new PrologList(initWorld);
            this.playerKnowledge = new PrologList(initPlayerKnowledge);
            this.playerPercepts = new PrologList(initPlayerPercepts);
        }
    }

    private class SimulationStatus {
        PrologList world;
        DecoratedStruct playerAction;
        PrologList playerKnowledge;
        PrologList playerPercepts;
        int points;
        Struct gameStatus;
        Dimension displaySize;
        PrologList display;

        private SimulationStatus(InitWorldSnapshot snapshot) {
            this.world = snapshot.world;
            this.playerKnowledge = snapshot.playerKnowledge;
            this.playerPercepts = snapshot.playerPercepts;
        }

        public void writeReact(Term gameStatus, Term world, Term playerPercepts) throws JovologEngineException {
            if (!(gameStatus instanceof Struct)) {
                throw new JovologEngineException(String.format(JovologEngine.MSG_INVALID_STRUCT, gameStatus));
            }
            this.gameStatus = (Struct)gameStatus;
            this.world = new PrologList(world);
            this.playerPercepts = new PrologList(playerPercepts);
        }

        public void writeDisplay(Term displaySize, Term display) throws JovologEngineException {
            if (!(displaySize instanceof Struct)) {
                throw new JovologEngineException(String.format(JovologEngine.MSG_INVALID_STRUCT, displaySize));
            }
            Struct sDisplaySize = (Struct)displaySize;
            this.displaySize = new Dimension(Integer.parseInt(sDisplaySize.getArg(0).toString()), Integer.parseInt(sDisplaySize.getArg(1).toString()));
            this.display = new PrologList(display);
        }

        public void writeAct(Term playerAction, Term playerKnowledge) throws JovologEngineException {
            this.playerAction = new DecoratedStruct(playerAction);
            this.playerKnowledge = new PrologList(playerKnowledge);
        }

        private void writePoints(Term points) {
            this.points = Integer.parseInt(points.toString());
        }

        private boolean ended() {
            return !this.gameStatus.getName().equals(JovologEngine.TERMNAME_SIMULATION_CONTINUE);
        }

        private int getPoints() {
            return this.points;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrologList
    implements Iterable<Term> {
        private static final int WITH_COMMAS = 0;
        private static final int WITH_DOTS = 1;
        private Struct list;

        private PrologList(Term term) throws JovologEngineException {
            if (!term.isList()) {
                throw new JovologEngineException(String.format(JovologEngine.MSG_INVALID_LIST, term));
            }
            this.list = (Struct)term;
        }

        private PrologList(String predicates) throws JovologEngineException {
            Term term;
            StringTokenizer tokens = new StringTokenizer(predicates, "\n");
            StringBuilder sb = new StringBuilder("[");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                token = token.substring(0, token.length() - 1);
                sb.append(token).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
            try {
                term = Term.createTerm((String)sb.toString());
            }
            catch (InvalidTermException ex) {
                throw new JovologEngineException(String.format(JovologEngine.MSG_INVALID_TERM, sb.toString()));
            }
            if (!term.isList()) {
                throw new JovologEngineException(String.format(JovologEngine.MSG_INVALID_LIST, term));
            }
            this.list = (Struct)term;
        }

        @Override
        public Iterator<Term> iterator() {
            return new Iterator<Term>(){
                Struct curr;
                {
                    this.curr = PrologList.this.list;
                }

                @Override
                public boolean hasNext() {
                    return this.curr.getArity() > 0;
                }

                @Override
                public Term next() {
                    Term item = this.curr.getArg(0);
                    this.curr = this.curr.getArg(1) instanceof Var ? (Struct)this.curr.getArg(1).getTerm() : (Struct)this.curr.getArg(1);
                    return item;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        private void appendTo(Prolog engine) {
            for (Term predicate : this) {
                engine.solve(JovologEngine.this.appendTerm(predicate));
            }
        }

        public String toString() {
            return this.toString(1);
        }

        public String toString(int mode) {
            StringBuilder sb = new StringBuilder();
            for (Term term : this) {
                sb.append(term).append(mode == 0 ? "," : ".\n");
            }
            return sb.toString();
        }

        private DecoratedStruct wrap(String termname) {
            return new DecoratedStruct(Term.createTerm((String)(termname + "(" + this.list + ")")));
        }

        private PrologList wrapEach(String wrapping) throws JovologEngineException {
            StringBuilder sb = new StringBuilder("[");
            for (Term term : this) {
                sb.append(wrapping).append("(").append(term).append("),");
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
            return new PrologList(Term.createTerm((String)sb.toString()));
        }

        private void concatenate(Term term) throws JovologEngineException {
            PrologList list = new PrologList(term);
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.toString(0));
            sb.append(list.toString(0));
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
            this.list = (Struct)Term.createTerm((String)sb.toString());
        }
    }
}

