/*
 * Decompiled with CFR 0.152.
 */
package jovolog.utils;

import alice.tuprolog.Theory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jovolog.Jovolog;

public class IOManager {
    public static final String PROLOG = "prolog";
    public static final String SEP = File.separator;

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public Theory getTheory(File playerFile) throws IOException {
        return new Theory((InputStream)this.getFileInputStream(playerFile));
    }

    public File chooseFile(String filetype) {
        JFileChooser chooser = new JFileChooser(".");
        FileNameExtensionFilter filter = new FileNameExtensionFilter(this.getLabel(filetype), this.getExtensions(filetype));
        chooser.setFileFilter(filter);
        chooser.showOpenDialog(Jovolog.getApplication().getMainFrame());
        return chooser.getSelectedFile();
    }

    private String[] getExtensions(String filetype) {
        if (filetype.equals(PROLOG)) {
            return new String[]{"pl"};
        }
        Logger.getLogger(Jovolog.class.getName()).log(Level.SEVERE, "CONTRACT VIOLATION FALLOVER: filetype not found");
        return null;
    }

    private String getLabel(String filetype) {
        if (filetype.equals(PROLOG)) {
            return "Prolog files";
        }
        Logger.getLogger(Jovolog.class.getName()).log(Level.SEVERE, "CONTRACT VIOLATION FALLOVER: filetype not found");
        return null;
    }

    public BufferedImage getImage(String path) throws IOException {
        BufferedImage img = null;
        img = ImageIO.read(new File("images" + SEP + path));
        return img;
    }
}

