/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.tuprolog.event.SpyEvent;
import alice.tuprolog.event.SpyListener;
import alice.tuprolog.event.WarningEvent;
import alice.tuprolog.event.WarningListener;
import alice.util.Automaton;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;

public class CUIConsole
extends Automaton
implements Serializable,
OutputListener,
SpyListener,
WarningListener {
    BufferedReader stdin;
    Prolog engine;
    SolveInfo info;
    static final String incipit = "tuProlog " + Prolog.getVersion() + " - DEIS,  Universit\ufffd di Bologna a Cesena \n" + new Date();

    public CUIConsole(String[] stringArray) {
        if (stringArray.length > 1) {
            System.err.println("args: { theory file }");
            System.exit(-1);
        }
        this.engine = new Prolog();
        this.stdin = new BufferedReader(new InputStreamReader(System.in));
        this.engine.addWarningListener((WarningListener)this);
        this.engine.addOutputListener((OutputListener)this);
        this.engine.addSpyListener((SpyListener)this);
        if (stringArray.length > 0) {
            try {
                this.engine.setTheory(new Theory((InputStream)new FileInputStream(stringArray[0])));
            }
            catch (InvalidTheoryException invalidTheoryException) {
                System.err.println("invalid theory - line: " + invalidTheoryException.line);
                System.exit(-1);
            }
            catch (Exception exception) {
                System.err.println("invalid theory.");
                System.exit(-1);
            }
        }
    }

    public void boot() {
        System.out.println(incipit);
        this.become("goalRequest");
    }

    public void goalRequest() {
        String string = "";
        while (string.equals("")) {
            System.out.print("\n?- ");
            try {
                string = this.stdin.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.solveGoal(string);
    }

    void solveGoal(String string) {
        try {
            this.info = this.engine.solve(string);
            if (this.engine.isHalted()) {
                System.exit(0);
            }
            if (!this.info.isSuccess()) {
                System.out.println("no.");
                this.become("goalRequest");
            } else if (!this.engine.hasOpenAlternatives()) {
                String string2 = this.info.toString();
                if (string2.equals("")) {
                    System.out.println("yes.");
                } else {
                    System.out.println(this.solveInfoToString(this.info) + "\nyes.");
                }
                this.become("goalRequest");
            } else {
                String string3 = this.solveInfoToString(this.info);
                System.out.print((string3 == "" ? "true" : string3) + " ? ");
                this.become("getChoice");
            }
        }
        catch (MalformedGoalException malformedGoalException) {
            System.out.println("syntax error in goal:\n" + string);
            this.become("goalRequest");
        }
    }

    private String solveInfoToString(SolveInfo solveInfo) {
        String string = "";
        try {
            Iterator iterator = solveInfo.getBindingVars().iterator();
            while (iterator.hasNext()) {
                Var var = (Var)iterator.next();
                if (var == null || var.isAnonymous() || !var.isBound() || var.getTerm() instanceof Var && ((Var)var.getTerm()).getName().startsWith("_")) continue;
                string = string + var.getName() + " / " + var.getTerm();
                if (!iterator.hasNext()) continue;
                string = string + "\n";
            }
        }
        catch (NoSolutionException noSolutionException) {
            // empty catch block
        }
        return string;
    }

    public void getChoice() {
        String string = "";
        try {
            while (!(string = this.stdin.readLine()).equals(";") && !string.equals("")) {
                System.out.println("\nAction ( ';' for more choices, otherwise <return> ) ");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals(";")) {
            System.out.println("yes.");
            this.engine.solveEnd();
            this.become("goalRequest");
        } else {
            try {
                System.out.println();
                this.info = this.engine.solveNext();
                if (!this.info.isSuccess()) {
                    System.out.println("no.");
                    this.become("goalRequest");
                } else {
                    String string2 = this.solveInfoToString(this.info);
                    System.out.print((string2 == "" ? "true" : string2) + " ? ");
                    this.become("getChoice");
                }
            }
            catch (Exception exception) {
                System.out.println("no.");
                this.become("goalRequest");
            }
        }
    }

    public void onOutput(OutputEvent outputEvent) {
        System.out.print(outputEvent.getMsg());
    }

    public void onSpy(SpyEvent spyEvent) {
        System.out.println(spyEvent.getMsg());
    }

    public void onWarning(WarningEvent warningEvent) {
        System.out.println(warningEvent.getMsg());
    }

    public static void main(String[] stringArray) {
        new Thread((Runnable)((Object)new CUIConsole(stringArray))).start();
    }
}

