/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Prolog;
import alice.tuprolog.event.LibraryListener;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.tuprolog.event.QueryListener;
import alice.tuprolog.event.SpyEvent;
import alice.tuprolog.event.SpyListener;
import alice.tuprolog.event.WarningEvent;
import alice.tuprolog.event.WarningListener;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.JavaEditArea;
import alice.tuprologx.ide.JavaIOManager;
import alice.tuprologx.ide.JavaInputField;
import alice.tuprologx.ide.LibraryDialog;
import alice.tuprologx.ide.LibraryManager;
import alice.tuprologx.ide.SwingFrameLauncher;
import alice.tuprologx.ide.ThinletConsole;
import alice.tuprologx.ide.ThinletDebugArea;
import alice.tuprologx.ide.ThinletStatusBar;
import alice.tuprologx.ide.ThinletTheoryEditor;
import alice.tuprologx.ide.ThinletToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JavaIDE
extends JFrame
implements IDE {
    private ThinletTheoryEditor editor;
    private JavaEditArea editArea;
    private ThinletToolBar toolBar;
    private Prolog engine;

    public JavaIDE() {
        super("tuProlog IDE");
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.engine = new Prolog();
        System.out.println("tuProlog system - release " + Prolog.getVersion());
        ThinletDebugArea thinletDebugArea = new ThinletDebugArea();
        ThinletStatusBar thinletStatusBar = new ThinletStatusBar();
        this.editor = new ThinletTheoryEditor();
        this.editor.setEngine(this.engine);
        this.editor.addPropertyChangeListener(thinletStatusBar);
        jPanel.add((Component)this.editor, "North");
        this.editArea = new JavaEditArea();
        this.editor.setEditArea(this.editArea);
        this.editArea.addPropertyChangeListener(this.editor);
        jPanel.add((Component)this.editArea, "Center");
        this.editArea.setBackground(new Color(230, 230, 230));
        ThinletConsole thinletConsole = new ThinletConsole(this);
        thinletConsole.setEngine(this.engine);
        thinletConsole.addPropertyChangeListener(thinletStatusBar);
        thinletConsole.setStatusMessage("Ready.");
        this.engine.addQueryListener((QueryListener)thinletConsole);
        JavaInputField javaInputField = new JavaInputField();
        javaInputField.setBackground(new Color(230, 230, 230));
        thinletConsole.setInputField(javaInputField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)javaInputField, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)thinletConsole, "Center");
        jPanel.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this.toolBar = new ThinletToolBar(this);
        this.toolBar.setEngine(this.engine);
        jPanel4.add((Component)this.toolBar, "North");
        jPanel4.add((Component)jPanel, "Center");
        this.toolBar.addPropertyChangeListener(thinletStatusBar);
        this.toolBar.setDebugArea(thinletDebugArea);
        this.toolBar.setFileManager(new JavaIOManager(this.toolBar));
        SwingFrameLauncher swingFrameLauncher = new SwingFrameLauncher();
        swingFrameLauncher.setFrameIcon("img/tuProlog.gif");
        this.toolBar.setFrameLauncher(swingFrameLauncher);
        jPanel4.add((Component)thinletStatusBar, "South");
        LibraryManager libraryManager = new LibraryManager();
        libraryManager.setEngine(this.engine);
        LibraryDialog libraryDialog = new LibraryDialog(libraryManager);
        this.engine.addLibraryListener((LibraryListener)libraryDialog);
        this.toolBar.setLibraryDialog(libraryDialog);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(jPanel4);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("img/tuProlog.gif"));
        this.setIconImage(imageIcon.getImage());
        this.engine.addWarningListener((WarningListener)thinletDebugArea);
        this.engine.addOutputListener((OutputListener)thinletConsole);
        this.engine.addSpyListener((SpyListener)thinletDebugArea);
    }

    public void onOutput(OutputEvent outputEvent) {
        System.out.print(outputEvent.getMsg());
    }

    public void onSpy(SpyEvent spyEvent) {
        System.out.println(spyEvent.getMsg());
    }

    public void onWarning(WarningEvent warningEvent) {
        System.out.println(warningEvent.getMsg());
    }

    public void enableTheoryCommands(boolean bl) {
        this.editor.enableTheoryCommands(bl);
        this.toolBar.enableTheoryCommands(bl);
    }

    public boolean isFeededTheory() {
        return !this.editArea.isDirty();
    }

    public void setFeededTheory(boolean bl) {
        this.editArea.setDirty(!bl);
    }

    public String getEditorContent() {
        return this.editArea.getTheory();
    }

    public void setEditorContent(String string) {
        this.editArea.setTheory(string);
    }
}

