/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.TheoryEditArea;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ThinletTheoryEditor
extends Thinlet
implements PropertyChangeListener {
    private Prolog engine;
    private TheoryEditArea editArea;
    private String statusMessage;
    private PropertyChangeSupport propertyChangeSupport;

    public ThinletTheoryEditor() {
        try {
            this.add(this.parse("xml/ThinletTheoryEditor.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public Prolog getEngine() {
        return this.engine;
    }

    public void setEngine(Prolog prolog) {
        this.engine = prolog;
    }

    public void setStatusMessage(String string) {
        String string2 = this.getStatusMessage();
        this.statusMessage = string;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", string2, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setEditArea(TheoryEditArea theoryEditArea) {
        this.editArea = theoryEditArea;
    }

    public void setEngineTheory() {
        String string = this.editArea.getTheory();
        try {
            this.getEngine().setTheory(new Theory(string));
            this.editArea.setDirty(false);
            this.setStatusMessage("New theory accepted.");
        }
        catch (InvalidTheoryException invalidTheoryException) {
            this.setStatusMessage("Error setting theory: Syntax Error at/before line " + invalidTheoryException.line);
        }
    }

    public void getEngineTheory() {
        String string = this.getEngine().getTheory().toString();
        this.editArea.setTheory(string);
        this.setStatusMessage("Engine theory displayed.");
    }

    public void undo() {
        this.editArea.undoAction();
    }

    public void redo() {
        this.editArea.redoAction();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("caretLine")) {
            this.setCaretLine(propertyChangeEvent.getNewValue().toString());
        }
    }

    private void setCaretLine(String string) {
        Object object = this.find("lineField");
        this.setString(object, "text", string);
    }

    protected void enableTheoryCommands(boolean bl) {
        Object object = this.find("setTheoryButton");
        this.setBoolean(object, "enabled", bl);
    }
}

